/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.internal.json;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import jirarest.com.atlassian.jira.rest.client.api.ExpandableProperty;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jirarest.com.atlassian.jira.rest.client.api.domain.User;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jirarest.org.codehaus.jettison.json.JSONException;
import jirarest.org.codehaus.jettison.json.JSONObject;

public class UserJsonParser
implements JsonObjectParser<User> {
    @Override
    public User parse(JSONObject json) throws JSONException {
        BasicUser basicUser = (BasicUser)Preconditions.checkNotNull((Object)JsonParseUtil.parseBasicUser(json));
        String timezone = JsonParseUtil.getOptionalString(json, "timeZone");
        String avatarUrl = JsonParseUtil.getOptionalString(json, "avatarUrl");
        HashMap avatarUris = Maps.newHashMap();
        if (avatarUrl != null) {
            URI avatarUri = JsonParseUtil.parseURI(avatarUrl);
            avatarUris.put("48x48", avatarUri);
        } else {
            JSONObject avatarUrlsJson = json.getJSONObject("avatarUrls");
            Iterator iterator = avatarUrlsJson.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                avatarUris.put(key, JsonParseUtil.parseURI(avatarUrlsJson.getString(key)));
            }
        }
        String emailAddress = JsonParseUtil.getOptionalString(json, "emailAddress");
        boolean active = Boolean.parseBoolean(JsonParseUtil.getOptionalString(json, "active"));
        ExpandableProperty<String> groups = JsonParseUtil.parseOptionalExpandableProperty(json.optJSONObject("groups"), new JsonObjectParser<String>(){

            @Override
            public String parse(JSONObject json) throws JSONException {
                return json.getString("name");
            }
        });
        return new User(basicUser.getSelf(), basicUser.getName(), basicUser.getDisplayName(), basicUser.getAccountId(), emailAddress, active, groups, avatarUris, timezone);
    }
}

