/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.workflow.automjira.client.JiraClient;
import org.squashtest.tm.plugin.workflow.automjira.domain.Configuration;
import org.squashtest.tm.plugin.workflow.automjira.domain.ConfigurationForProject;
import org.squashtest.tm.plugin.workflow.automjira.domain.CustomFieldInfo;
import org.squashtest.tm.plugin.workflow.automjira.domain.RestThirdPartyServer;
import org.squashtest.tm.plugin.workflow.automjira.helpers.Util;
import org.squashtest.tm.plugin.workflow.automjira.repository.PluginDao;
import org.squashtest.tm.plugin.workflow.automjira.service.ConfigurationService;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationService;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.servers.CredentialsProvider;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import workflowautomjira.com.atlassian.jira.rest.client.api.RestClientException;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.BasicProject;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.Issue;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.IssueType;

@Service
@Transactional
public class ConfigurationServiceImpl
implements ConfigurationService {
    @Inject
    private PluginDao pluginDao;
    @Inject
    private CredentialsProvider credentialsProvider;
    @Inject
    private InternationalizationHelper i18nhelper;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private InternationalizationHelper inHelper;
    @Inject
    private BugTrackerFinderService serverFinder;
    @Inject
    private Provider<JiraClient> provider;
    @Inject
    private BugTrackerManagerService btService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private GenericProjectManagerService projectManager;
    @Inject
    private SynchronizationService synchronizationService;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private RemoteSynchronisationDao remoteSynchronisationDao;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Configuration getConfigurationPage(Long projectId) throws IOException {
        List<IssueType> listRequestTypes = null;
        Map conf = this.projectManager.getPluginConfiguration(projectId.longValue(), WorkspaceType.TEST_CASE_WORKSPACE, "henix.plugin.automation.workflow.automjira");
        Configuration configuration = new Configuration();
        List bugtrackers = this.btService.findByKind("jira.rest");
        List cloudBugtrackers = this.btService.findByKind("jira.cloud");
        bugtrackers.addAll(cloudBugtrackers);
        List<BasicProject> listProjects = this.initListProjects(conf);
        boolean isProjectStillExist = listProjects.stream().anyMatch(it -> it.getKey().equals(conf.get("projectKey")));
        if (isProjectStillExist) {
            listRequestTypes = this.initListRequestType(conf);
        }
        configuration.setServers(this.configurationService.toRestServers(bugtrackers));
        configuration.setRequestTypes(listRequestTypes);
        configuration.setProjects(listProjects);
        return configuration;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public ConfigurationForProject getConfigurationForProject(Long projectId) throws IOException {
        ConfigurationForProject confForProject = this.pluginDao.loadConfigurationForProject(projectId);
        confForProject.setProjectId(projectId);
        return confForProject;
    }

    @Override
    public Collection<RestThirdPartyServer> toRestServers(List<BugTracker> btrackers) {
        List<RestThirdPartyServer> servers = btrackers.stream().filter(bt -> this.credentialsProvider.hasAppLevelCredentials((ThirdPartyServer)bt)).map(bt -> new RestThirdPartyServer(bt.getId(), bt.getName(), bt.getUrl())).collect(Collectors.toList());
        String nullServerName = this.i18nhelper.internationalize("label.None", Util.getLocale());
        RestThirdPartyServer nullServer = new RestThirdPartyServer(0L, nullServerName, null);
        servers.add(0, nullServer);
        return servers;
    }

    @Override
    public void addRemoteSynchronisation(Long projectId, Map<String, String> conf) {
        RemoteSynchronisation sync = null;
        List listSync = this.remoteSynchronisationDao.findByProjectIdAndKind(projectId, "henix.plugin.automation.workflow.automjira");
        if (listSync.isEmpty()) {
            sync = new RemoteSynchronisation();
        } else {
            Iterator iterator = listSync.iterator();
            while (iterator.hasNext()) {
                RemoteSynchronisation existingSync;
                sync = existingSync = (RemoteSynchronisation)iterator.next();
            }
        }
        Project project = (Project)this.projectDao.getReferenceById((Object)projectId);
        BugTracker bugtracker = this.serverFinder.findById(Long.parseLong(conf.get("serverForProject")));
        sync.setKind("henix.plugin.automation.workflow.automjira");
        sync.setName("automJiraSync");
        sync.setProject(project);
        sync.setServer(bugtracker);
        sync.setSelectType("QUERY");
        sync.setSelectValue(this.createQuery(conf));
        sync.setSynchronisationEnable(true);
        this.entityManager.persist((Object)sync);
        this.entityManager.flush();
    }

    @Override
    public List<CustomFieldInfo> getMandatoryCustomFieldsByIssueTypeId(String projectKey, Long issueTypeId, Long idServer) {
        List<CustomFieldInfo> mapIssueTypeWithMandatoryCuf;
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (JiraClient jiraClient = (JiraClient)this.provider.get();){
                BugTracker bugtracker = this.serverFinder.findById(idServer.longValue());
                jiraClient.jiraClientAuthentication(bugtracker);
                mapIssueTypeWithMandatoryCuf = jiraClient.listMandatoryCufsInfoForIssueType(projectKey, issueTypeId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (BugTrackerNoCredentialsException ex) {
            String message = this.i18nhelper.internationalize("thirdpartyserver.admin.messages.testcreds.fail", Util.getLocale());
            throw new BugTrackerNoCredentialsException(message, (Throwable)ex);
        }
        return mapIssueTypeWithMandatoryCuf;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void configurePlugin(Long projectId, ConfigurationForProject configForProject) throws JsonProcessingException {
        Map<String, String> conf = this.pluginDao.storeConfigurationForProject(projectId, configForProject);
        if (conf != null) {
            this.addRemoteSynchronisation(projectId, conf);
        }
    }

    @Override
    public List<BasicProject> initEmptyListProjectsJira() {
        String nullProjectName = this.i18nhelper.internationalize("label.None", Util.getLocale());
        return Collections.singletonList(new BasicProject(null, "", 0L, nullProjectName));
    }

    @Override
    public List<IssueType> initEmptyListRequestType() {
        String nullProjectName = this.i18nhelper.internationalize("label.None", Util.getLocale());
        return Collections.singletonList(new IssueType(null, 0L, nullProjectName, false, "", null));
    }

    @Override
    public List<BasicProject> getProjectByIdServer(Long idServer) {
        List<BasicProject> listProjects;
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        BugTracker bugtracker = this.serverFinder.findById(idServer.longValue());
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JiraClient jiraClient = (JiraClient)this.provider.get();){
                jiraClient.jiraClientAuthentication(bugtracker);
                listProjects = Util.toList(jiraClient.getAllVisibleProjects());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchElementException | BugTrackerNoCredentialsException ex) {
            String message = this.i18nhelper.getMessage("workflow.automation.jira.server.no-credentials-message", new Object[]{bugtracker.getName()}, "Unable to connect to or retrieve projects from bugtracker. Please check that the server credentials and configuration are correct.", Util.getLocale());
            throw new BugTrackerNoCredentialsException(message, ex);
        }
        return listProjects;
    }

    @Override
    public List<IssueType> getRequestTypesByProject(String projectKey, Long serverId) throws IOException {
        List<IssueType> listRequestType;
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (JiraClient jiraClient = (JiraClient)this.provider.get();){
                BugTracker bugtracker = this.serverFinder.findById(serverId.longValue());
                jiraClient.jiraClientAuthentication(bugtracker);
                listRequestType = Util.toList(jiraClient.getRequestTypesByProject(projectKey));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (BugTrackerNoCredentialsException ex) {
            String message = this.i18nhelper.internationalize("thirdpartyserver.admin.messages.testcreds.fail", Util.getLocale());
            throw new BugTrackerNoCredentialsException(message, (Throwable)ex);
        }
        return listRequestType;
    }

    @Override
    public void removeConfigurationPlugin(Long projectId) {
        this.pluginDao.removeConfigurationPlugin(projectId);
    }

    @Override
    public Issue getRemoteIssueKey(String remoteIssueKey, Long serverId) throws RestClientException {
        BugTracker bugtracker = this.serverFinder.findById(serverId.longValue());
        return this.synchronizationService.findRemoteIssueByKey(remoteIssueKey, bugtracker);
    }

    @Override
    public List<IssueType> initListRequestType(Map<String, String> conf) throws IOException {
        List<Object> listRequestTypes = new ArrayList();
        Long serverId = null;
        if (conf.isEmpty()) {
            listRequestTypes = this.configurationService.initEmptyListRequestType();
        } else {
            String projectKey = conf.get("projectKey");
            if (conf.containsKey("serverForProject")) {
                serverId = Long.valueOf(conf.get("serverForProject"));
            }
            if (!StringUtils.isBlank((CharSequence)projectKey) && serverId != null && !serverId.equals(0L)) {
                listRequestTypes = Util.toList(this.configurationService.getRequestTypesByProject(projectKey, serverId));
            }
        }
        return listRequestTypes;
    }

    @Override
    public List<BasicProject> initListProjects(Map<String, String> conf) throws IOException {
        List<Object> listProjects = new ArrayList();
        if (conf.isEmpty()) {
            listProjects = this.configurationService.initEmptyListProjectsJira();
        } else {
            Long idServer;
            Long l = idServer = conf.get("serverForProject") != null ? Long.valueOf(conf.get("serverForProject")) : null;
            if (idServer != null && !idServer.equals(0L)) {
                listProjects = Util.toList(this.configurationService.getProjectByIdServer(idServer));
            }
        }
        return listProjects;
    }

    private void validateFields(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new PluginValidationException(this.inHelper.internationalize("workflow.automation.jira.empty.field", Util.getLocale()));
        }
    }

    private String createQuery(Map<String, String> conf) {
        return "project =" + conf.get("projectKey") + " AND issuetype = " + conf.get("requestType");
    }
}

