/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.repository;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.domain.tf.automationrequest.RemoteAutomationRequestExtender;

@Repository
public class SynchronisationDao {
    @PersistenceContext
    private EntityManager em;
    private static final String FIND_SYNC_FOR_AUTOMJIRA = "SELECT sync.id FROM RemoteSynchronisation sync INNER JOIN sync.project p WHERE sync.kind = :pluginId AND sync.synchronisationEnable = true";
    private static final String FIND_REMOTE_SYNCHRONISATION_ByIds = "SELECT sync FROM RemoteSynchronisation sync  WHERE  sync.id = :synchronizationId AND sync.synchronisationEnable = true";
    private static final String FIND_REMOTE_AUTOMATION_REQUEST_EXTENDER = "SELECT rare FROM RemoteAutomationRequestExtender rare  INNER JOIN rare.automationRequest ar  INNER JOIN ar.project p  Where p.id in(SELECT sync.project.id FROM RemoteSynchronisation sync INNER JOIN sync.project p WHERE sync.id = :synchronizationId)";
    private static final String FIND_RARE_BY_PROJECT_ID = "Select rare From RemoteAutomationRequestExtender rare  INNER JOIN rare.automationRequest ar INNER JOIN ar.project p  WHERE p.id = :projectId ";
    private static final String FIND_RARE_BY_LIST_ISSUE_KEY = "SELECT rare FROM RemoteAutomationRequestExtender rare where rare.remoteIssueKey in( :listIssueKey)";
    private static final String FIND_RARE_BY_ISSUE_KEY_SERVER_ID = "SELECT rare FROM RemoteAutomationRequestExtender rare INNER JOIN rare.server s where rare.remoteIssueKey = :issueKey and s.id = :serverId";
    private static final String FIND_LIST_REMOTE_SYNCHRONISATION_ByIds = "SELECT sync FROM RemoteSynchronisation sync   JOIN FETCH sync.project p  JOIN FETCH sync.server s WHERE  sync.id in( :listSynchronizationIds) AND sync.synchronisationEnable = true";
    public static final String REMOTE_AUTOMATION_REQUEST_EXTENDER_SQL_REMOVE = "delete from REMOTE_AUTOMATION_REQUEST_EXTENDER where remote_automation_request_extender_id = :rareId";

    public List<Long> findSynchronizationIds(String pluginId) {
        Query query = this.em.createQuery(FIND_SYNC_FOR_AUTOMJIRA);
        query.setParameter("pluginId", (Object)pluginId);
        List remoteSynchronisations = query.getResultList();
        return remoteSynchronisations;
    }

    public List<RemoteAutomationRequestExtender> findRemoteAutoReqExtenderSyncId(Long synchronizationId) {
        Query query = this.em.createQuery(FIND_REMOTE_AUTOMATION_REQUEST_EXTENDER);
        query.setParameter("synchronizationId", (Object)synchronizationId);
        List listRemoteAutoReqExtender = query.getResultList();
        return listRemoteAutoReqExtender;
    }

    public RemoteSynchronisation getRemoteSynchronization(Long synchronizationId) {
        Query query = this.em.createQuery(FIND_REMOTE_SYNCHRONISATION_ByIds);
        query.setParameter("synchronizationId", (Object)synchronizationId);
        return (RemoteSynchronisation)query.getSingleResult();
    }

    public List<RemoteAutomationRequestExtender> findListRareByProjectId(Long projectId) {
        Query query = this.em.createQuery(FIND_RARE_BY_PROJECT_ID);
        query.setParameter("projectId", (Object)projectId);
        return query.getResultList();
    }

    public List<RemoteAutomationRequestExtender> findListRareByIssueKey(List<String> listIssueKey) {
        List<Object> listRareByIssueKey = new ArrayList<RemoteAutomationRequestExtender>();
        if (listIssueKey.size() == 0) {
            return listRareByIssueKey;
        }
        Query query = this.em.createQuery(FIND_RARE_BY_LIST_ISSUE_KEY);
        query.setParameter("listIssueKey", listIssueKey);
        listRareByIssueKey = query.getResultList();
        return listRareByIssueKey;
    }

    public RemoteAutomationRequestExtender findRareByIssueKeyAndServerId(Long serverId, String issueKey) {
        Query query = this.em.createQuery(FIND_RARE_BY_ISSUE_KEY_SERVER_ID);
        query.setParameter("issueKey", (Object)issueKey);
        query.setParameter("serverId", (Object)serverId);
        return (RemoteAutomationRequestExtender)query.getSingleResult();
    }

    public List<RemoteSynchronisation> getListRemoteSynchronization(List<Long> listSynchronizationIds) {
        List<Object> listRemoteSynchronisation = new ArrayList<RemoteSynchronisation>();
        if (listSynchronizationIds.size() == 0) {
            return listRemoteSynchronisation;
        }
        Query query = this.em.createQuery(FIND_LIST_REMOTE_SYNCHRONISATION_ByIds);
        query.setParameter("listSynchronizationIds", listSynchronizationIds);
        listRemoteSynchronisation = query.getResultList();
        return listRemoteSynchronisation;
    }

    public void removeRemoteAutomationRequestExtender(RemoteAutomationRequestExtender rare) {
        Query query = this.em.createNativeQuery(REMOTE_AUTOMATION_REQUEST_EXTENDER_SQL_REMOVE);
        query.setParameter("rareId", (Object)rare.getId());
        query.executeUpdate();
        this.em.flush();
        this.em.clear();
    }
}

