/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.plugin.workflow.automjira.domain.Configuration;
import org.squashtest.tm.plugin.workflow.automjira.domain.ConfigurationForProject;
import org.squashtest.tm.plugin.workflow.automjira.domain.CustomFieldInfo;
import org.squashtest.tm.plugin.workflow.automjira.service.ConfigurationService;
import org.squashtest.tm.service.project.GenericProjectFinder;
import workflowautomjira.com.atlassian.jira.rest.client.api.RestClientException;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.BasicProject;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.IssueType;

@Controller(value="squash.tm.plugin.automjira.configurationController")
@RequestMapping(value={"backend/plugin/waj/configuration/project/{projectId}"})
public class ConfigurationController {
    private final ConfigurationService pluginService;
    private final GenericProjectFinder genericProjectFinder;

    public ConfigurationController(ConfigurationService pluginService, GenericProjectFinder genericProjectFinder) {
        this.pluginService = pluginService;
        this.genericProjectFinder = genericProjectFinder;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public ConfigPageModel getConfigForProject(@PathVariable(value="projectId") Long projectId) throws IOException {
        ConfigPageModel configPageModel = new ConfigPageModel();
        configPageModel.setConfigurationForProject(this.pluginService.getConfigurationForProject(projectId));
        configPageModel.setPluginConfiguration(this.pluginService.getConfigurationPage(projectId));
        configPageModel.setProject(this.genericProjectFinder.findById(projectId.longValue()));
        return configPageModel;
    }

    @GetMapping(value={"/server/{serverId}/projects"})
    @ResponseBody
    public Iterable<BasicProject> getProjectByIdServer(@PathVariable(value="serverId") Long serverId) throws IOException {
        List<BasicProject> listProjects = null;
        listProjects = serverId != 0L ? this.pluginService.getProjectByIdServer(serverId) : this.pluginService.initEmptyListProjectsJira();
        return listProjects;
    }

    @GetMapping(value={"/server/{serverId}/projects/{projectKey}/request-types"})
    @ResponseBody
    public List<IssueType> getRequestTypeByIdServer(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="serverId") Long serverId) throws IOException {
        List<IssueType> listRequestType = projectKey != null ? this.pluginService.getRequestTypesByProject(projectKey, serverId) : this.pluginService.initEmptyListRequestType();
        return listRequestType;
    }

    @GetMapping(value={"/server/{serverId}/projects/{projectKey}/issueType/{issueTypeId}/mandatoryCufs"})
    @ResponseBody
    public List<CustomFieldInfo> getMandatoryCufsForIssueType(@PathVariable(value="projectKey") String projectKey, @PathVariable(value="serverId") Long serverId, @PathVariable(value="issueTypeId") Long issueTypeId) {
        List<CustomFieldInfo> mapIssueTypeWithMandatoryCuf = this.pluginService.getMandatoryCustomFieldsByIssueTypeId(projectKey, issueTypeId, serverId);
        return mapIssueTypeWithMandatoryCuf;
    }

    @GetMapping(value={"/server/{serverId}/remoteIssue/{remoteIssueKey}"})
    @ResponseBody
    public boolean remoteIssueExist(@PathVariable(value="remoteIssueKey") String remoteIssueKey, @PathVariable(value="serverId") Long serverId) throws RestClientException {
        return this.pluginService.getRemoteIssueKey(remoteIssueKey, serverId) != null;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public void configurePlugin(@PathVariable(value="projectId") Long projectId, @RequestBody ConfigurationForProject configForProject) throws JsonProcessingException {
        this.pluginService.configurePlugin(projectId, configForProject);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    public void removeConfigurationPlugin(@PathVariable(value="projectId") Long projectId) {
        this.pluginService.removeConfigurationPlugin(projectId);
    }

    static class ConfigPageModel {
        private GenericProject project;
        private Configuration pluginConfiguration;
        private ConfigurationForProject configurationForProject;

        ConfigPageModel() {
        }

        public GenericProject getProject() {
            return this.project;
        }

        public void setProject(GenericProject project) {
            this.project = project;
        }

        public Configuration getPluginConfiguration() {
            return this.pluginConfiguration;
        }

        public void setPluginConfiguration(Configuration pluginConfiguration) {
            this.pluginConfiguration = pluginConfiguration;
        }

        public ConfigurationForProject getConfigurationForProject() {
            return this.configurationForProject;
        }

        public void setConfigurationForProject(ConfigurationForProject configurationForProject) {
            this.configurationForProject = configurationForProject;
        }
    }
}

