/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.internal;

import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.Membership;
import com.taskadapter.redmineapi.bean.Project;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedRole;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedTracker;

public class ExtendedURIConfigurator {
    private static final String URL_POSTFIX = ".json";
    private static final Map<Class<?>, String> URLS = new HashMap();
    private final URL baseURL;
    private final String apiAccessKey;

    static {
        URLS.put(ExtendedCustomField.class, "extended_custom_fields");
        URLS.put(ExtendedTracker.class, "extended_tracker");
        URLS.put(ExtendedRole.class, "extended_role");
        URLS.put(IssueCategory.class, "extended_category");
        URLS.put(Project.class, "projects");
        URLS.put(Membership.class, "memberships");
    }

    public ExtendedURIConfigurator(String host, String apiAccessKey) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("The host parameter is NULL or empty");
        }
        try {
            this.baseURL = new URL(host);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Illegal host URL " + host, e);
        }
        this.apiAccessKey = apiAccessKey;
    }

    public URI createURI(String query) {
        return this.createURI(query, new ArrayList());
    }

    public URI createURI(String query, NameValuePair ... param) {
        return this.createURI(query, Arrays.asList(param));
    }

    private URI createURI(String query, Collection<? extends NameValuePair> origParams) {
        URI uri;
        ArrayList<? extends NameValuePair> params = new ArrayList<NameValuePair>(origParams);
        if (this.apiAccessKey != null) {
            params.add((NameValuePair)new BasicNameValuePair("key", this.apiAccessKey));
        }
        try {
            URL url = this.baseURL;
            String path = url.getPath();
            if (!query.isEmpty()) {
                path = String.valueOf(path) + "/" + query;
            }
            uri = URIUtils.createURI((String)url.getProtocol(), (String)url.getHost(), (int)url.getPort(), (String)path, (String)URLEncodedUtils.format(params, (String)"UTF-8"), null);
        }
        catch (URISyntaxException e) {
            throw new RedmineInternalError(e);
        }
        return uri;
    }

    public URI getChildObjectsURI(Class<?> parent, String parentId, Class<?> child, NameValuePair ... args) {
        String base = this.getConfig(parent);
        String detal = this.getConfig(child);
        return this.createURI(String.valueOf(base) + "/" + parentId + "/" + detal + URL_POSTFIX, args);
    }

    public URI getChildIdURI(Class<?> parent, String parentId, Class<?> child, int value) {
        String base = this.getConfig(parent);
        String detal = this.getConfig(child);
        return this.createURI(String.valueOf(base) + "/" + parentId + "/" + detal + "/" + value + URL_POSTFIX);
    }

    public URI getObjectsURI(Class<?> child, NameValuePair ... args) {
        String detal = this.getConfig(child);
        return this.createURI(String.valueOf(detal) + URL_POSTFIX, args);
    }

    public URI getObjectsURI(Class<?> child, Collection<? extends NameValuePair> args) {
        String detal = this.getConfig(child);
        return this.createURI(String.valueOf(detal) + URL_POSTFIX, args);
    }

    public URI getObjectURI(Class<?> object, String id, NameValuePair ... args) {
        String detal = this.getConfig(object);
        return this.createURI(String.valueOf(detal) + "/" + id + URL_POSTFIX, args);
    }

    private String getConfig(Class<?> item) {
        String guess = URLS.get(item);
        if (guess == null) {
            throw new RedmineInternalError("Unsupported item class " + item.getCanonicalName());
        }
        return guess;
    }

    public URI getUploadURI() {
        return this.createURI("uploads.json");
    }
}

