/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.websso;

import java.io.IOException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.X509KeyManager;
import org.opensaml.common.SAMLException;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.security.MetadataCriteria;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory;
import org.opensaml.ws.transport.http.HttpClientInTransport;
import org.opensaml.ws.transport.http.HttpClientOutTransport;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import sqsaml.org.apache.commons.httpclient.HostConfiguration;
import sqsaml.org.apache.commons.httpclient.HttpClient;
import sqsaml.org.apache.commons.httpclient.HttpMethodBase;
import sqsaml.org.apache.commons.httpclient.URI;
import sqsaml.org.apache.commons.httpclient.URIException;
import sqsaml.org.apache.commons.httpclient.methods.PostMethod;
import sqsaml.org.apache.commons.httpclient.protocol.Protocol;
import sqsaml.org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import sqsaml.org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import sqsaml.org.springframework.security.saml.context.SAMLMessageContext;
import sqsaml.org.springframework.security.saml.trust.X509TrustManager;
import sqsaml.org.springframework.security.saml.websso.ArtifactResolutionProfileBase;

public class ArtifactResolutionProfileImpl
extends ArtifactResolutionProfileBase {
    private HttpClient httpClient;

    public ArtifactResolutionProfileImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    protected void getArtifactResponse(String endpointURI, SAMLMessageContext context) throws SAMLException, MessageEncodingException, MessageDecodingException, MetadataProviderException, SecurityException {
        HttpMethodBase postMethod = null;
        try {
            URI uri = new URI(context.getPeerEntityEndpoint().getLocation(), true, "UTF-8");
            postMethod = new PostMethod();
            postMethod.setPath(uri.getPath());
            HostConfiguration hc = this.getHostConfiguration(uri, context);
            HttpClientOutTransport clientOutTransport = new HttpClientOutTransport((PostMethod)postMethod);
            HttpClientInTransport clientInTransport = new HttpClientInTransport((PostMethod)postMethod, endpointURI);
            context.setInboundMessageTransport(clientInTransport);
            context.setOutboundMessageTransport(clientOutTransport);
            boolean signMessage = context.getPeerExtendedMetadata().isRequireArtifactResolveSigned();
            this.processor.sendMessage(context, signMessage, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
            this.log.debug("Sending ArtifactResolution message to {}", (Object)uri);
            int responseCode = this.httpClient.executeMethod(hc, postMethod);
            if (responseCode != 200) {
                String responseBody = postMethod.getResponseBodyAsString();
                throw new MessageDecodingException("Problem communicating with Artifact Resolution service, received response " + responseCode + ", body " + responseBody);
            }
            this.processor.retrieveMessage(context, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        }
        catch (IOException e) {
            throw new MessageDecodingException("Error when sending request to artifact resolution service.", e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
    }

    protected HostConfiguration getHostConfiguration(URI uri, SAMLMessageContext context) throws MessageEncodingException {
        try {
            HostConfiguration hc = this.httpClient.getHostConfiguration();
            hc = hc != null ? new HostConfiguration(hc) : new HostConfiguration();
            if (uri.getScheme().equalsIgnoreCase("http")) {
                this.log.debug("Using HTTP configuration");
                hc.setHost(uri);
            } else {
                this.log.debug("Using HTTPS configuration");
                CriteriaSet criteriaSet = new CriteriaSet();
                criteriaSet.add(new EntityIDCriteria(context.getPeerEntityId()));
                criteriaSet.add(new MetadataCriteria(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "urn:oasis:names:tc:SAML:2.0:protocol"));
                criteriaSet.add(new UsageCriteria(UsageType.UNSPECIFIED));
                X509TrustManager trustManager = new X509TrustManager(criteriaSet, context.getLocalSSLTrustEngine());
                sqsaml.org.springframework.security.saml.trust.X509KeyManager manager = new sqsaml.org.springframework.security.saml.trust.X509KeyManager(context.getLocalSSLCredential());
                HostnameVerifier hostnameVerifier = context.getLocalSSLHostnameVerifier();
                SecureProtocolSocketFactory socketFactory = this.getSSLSocketFactory(context, manager, trustManager, hostnameVerifier);
                Protocol protocol = new Protocol("https", (ProtocolSocketFactory)socketFactory, 443);
                hc.setHost(uri.getHost(), uri.getPort(), protocol);
            }
            return hc;
        }
        catch (URIException e) {
            throw new MessageEncodingException("Error parsing remote location URI", e);
        }
    }

    protected SecureProtocolSocketFactory getSSLSocketFactory(SAMLMessageContext context, sqsaml.org.springframework.security.saml.trust.X509KeyManager manager, X509TrustManager trustManager, HostnameVerifier hostnameVerifier) {
        if (this.isHostnameVerificationSupported()) {
            return new TLSProtocolSocketFactory(manager, trustManager, hostnameVerifier);
        }
        return new TLSProtocolSocketFactory(manager, trustManager);
    }

    protected boolean isHostnameVerificationSupported() {
        try {
            TLSProtocolSocketFactory.class.getConstructor(X509KeyManager.class, javax.net.ssl.X509TrustManager.class, HostnameVerifier.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            this.log.warn("HostnameVerification is not supported, update your OpenSAML libraries");
            return false;
        }
    }
}

