/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.websso;

import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml2.binding.artifact.SAML2ArtifactType0004Builder;
import org.opensaml.saml2.core.Artifact;
import org.opensaml.saml2.core.ArtifactResolve;
import org.opensaml.saml2.core.ArtifactResponse;
import org.opensaml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.util.Base64;
import sqsaml.org.springframework.security.saml.context.SAMLMessageContext;
import sqsaml.org.springframework.security.saml.metadata.ExtendedMetadata;
import sqsaml.org.springframework.security.saml.util.SAMLUtil;
import sqsaml.org.springframework.security.saml.websso.AbstractProfileBase;
import sqsaml.org.springframework.security.saml.websso.ArtifactResolutionProfile;

public abstract class ArtifactResolutionProfileBase
extends AbstractProfileBase
implements ArtifactResolutionProfile {
    @Override
    public String getProfileIdentifier() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:artifact";
    }

    @Override
    public SAMLObject resolveArtifact(SAMLMessageContext context, String artifactId, String endpointURI) throws MessageDecodingException {
        try {
            SAML2ArtifactType0004 decodedArtifact = new SAML2ArtifactType0004Builder().buildArtifact(Base64.decode(artifactId));
            int endpointIndex = this.parseEndpointIndex(decodedArtifact.getEndpointIndex());
            EntityDescriptor idpEntityDescriptor = this.metadata.getEntityDescriptor(decodedArtifact.getSourceID());
            if (idpEntityDescriptor == null) {
                throw new MetadataProviderException("Cannot localize sender entity by SHA-1 hash from the artifact");
            }
            ExtendedMetadata extendedMetadata = this.metadata.getExtendedMetadata(idpEntityDescriptor.getEntityID());
            IDPSSODescriptor idpssoDescriptor = SAMLUtil.getIDPSSODescriptor(idpEntityDescriptor);
            ArtifactResolutionService artifactResolutionService = SAMLUtil.getArtifactResolutionService(idpssoDescriptor, endpointIndex);
            ArtifactResolve artifactResolve = this.createArtifactResolve(context, artifactId, artifactResolutionService);
            context.setCommunicationProfileId(this.getProfileIdentifier());
            context.setInboundSAMLBinding(artifactResolutionService.getBinding());
            context.setOutboundMessage(artifactResolve);
            context.setOutboundSAMLMessage(artifactResolve);
            context.setPeerEntityEndpoint(artifactResolutionService);
            context.setPeerEntityId(idpEntityDescriptor.getEntityID());
            context.setPeerEntityMetadata(idpEntityDescriptor);
            context.setPeerEntityRole(idpssoDescriptor.getElementQName());
            context.setPeerEntityRoleMetadata(idpssoDescriptor);
            context.setPeerExtendedMetadata(extendedMetadata);
            this.getArtifactResponse(endpointURI, context);
            ArtifactResponse artifactResponse = (ArtifactResponse)context.getInboundSAMLMessage();
            if (artifactResponse == null) {
                throw new MessageDecodingException("Did not receive an artifact response message.");
            }
            DateTime issueInstant = artifactResponse.getIssueInstant();
            if (!SAMLUtil.isDateTimeSkewValid(this.getResponseSkew(), issueInstant)) {
                throw new MessageDecodingException("ArtifactResponse issue time is either too old or with date in the future, skew " + this.getResponseSkew() + ", time " + issueInstant);
            }
            SAMLObject message = artifactResponse.getMessage();
            if (message == null) {
                throw new MessageDecodingException("No inbound message in artifact response message.");
            }
            return message;
        }
        catch (MetadataProviderException e) {
            throw new MessageDecodingException("Error processing metadata", e);
        }
        catch (MessageEncodingException e) {
            throw new MessageDecodingException("Could not encode artifact resolve message", e);
        }
        catch (MessageDecodingException e) {
            throw new MessageDecodingException("Could not decode artifact response message", e);
        }
        catch (SecurityException e) {
            throw new MessageDecodingException("Security error when decoding artifact response message", e);
        }
        catch (SAMLException e) {
            throw new MessageDecodingException("Error during message processing", e);
        }
    }

    protected abstract void getArtifactResponse(String var1, SAMLMessageContext var2) throws SAMLException, MessageEncodingException, MessageDecodingException, MetadataProviderException, SecurityException;

    protected ArtifactResolve createArtifactResolve(SAMLMessageContext context, String artifactId, Endpoint endpoint) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SAMLObjectBuilder artifactBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Artifact.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder artifactResolveBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(ArtifactResolve.DEFAULT_ELEMENT_NAME);
        Artifact artifact = (Artifact)artifactBuilder.buildObject();
        artifact.setArtifact(artifactId);
        ArtifactResolve artifactResolve = (ArtifactResolve)artifactResolveBuilder.buildObject();
        artifactResolve.setArtifact(artifact);
        this.buildCommonAttributes(context.getLocalEntityId(), artifactResolve, endpoint);
        return artifactResolve;
    }

    private int parseEndpointIndex(byte[] endpointIndexBytes) {
        int endpointIndex = 0;
        for (int i = 0; i < endpointIndexBytes.length; ++i) {
            endpointIndex = endpointIndex << i * 4 | endpointIndexBytes[i];
        }
        return endpointIndex;
    }
}

