/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.trust;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.opensaml.xml.security.x509.X509Credential;

public class X509KeyManager
implements javax.net.ssl.X509KeyManager {
    private static final String ALIAS_NAME = "constantAlias";
    private static final String[] ALIAS = new String[]{"constantAlias"};
    private String[] aliases;
    private String alias;
    private PrivateKey privateKey;
    private X509Certificate[] chain;

    public X509KeyManager(X509Credential credential) {
        if (credential != null) {
            this.privateKey = credential.getPrivateKey();
            this.chain = credential.getEntityCertificateChain().toArray(new X509Certificate[credential.getEntityCertificateChain().size()]);
            this.alias = ALIAS_NAME;
            this.aliases = ALIAS;
        } else {
            this.privateKey = null;
            this.chain = null;
            this.alias = null;
            this.aliases = null;
        }
    }

    @Override
    public String[] getClientAliases(String s, Principal[] principals) {
        return this.aliases;
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.alias;
    }

    @Override
    public String[] getServerAliases(String s, Principal[] principals) {
        return this.aliases;
    }

    @Override
    public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
        return this.alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String s) {
        return this.chain;
    }

    @Override
    public PrivateKey getPrivateKey(String s) {
        return this.privateKey;
    }
}

