/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.processor;

import java.util.List;
import org.opensaml.common.binding.security.SAMLProtocolMessageXMLSignatureSecurityPolicyRule;
import org.opensaml.saml2.binding.decoding.HTTPArtifactDecoderImpl;
import org.opensaml.saml2.binding.encoding.HTTPArtifactEncoder;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HTTPInTransport;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.signature.SignatureTrustEngine;
import sqsaml.org.apache.velocity.app.VelocityEngine;
import sqsaml.org.springframework.security.saml.context.SAMLMessageContext;
import sqsaml.org.springframework.security.saml.processor.SAMLBindingImpl;
import sqsaml.org.springframework.security.saml.websso.ArtifactResolutionProfile;

public class HTTPArtifactBinding
extends SAMLBindingImpl {
    public HTTPArtifactBinding(ParserPool parserPool, VelocityEngine velocityEngine, ArtifactResolutionProfile artifactProfile) {
        this(new HTTPArtifactDecoderImpl(artifactProfile, parserPool), new HTTPArtifactEncoder(velocityEngine, "/templates/saml2-post-artifact-binding.vm", null));
    }

    public HTTPArtifactBinding(MessageDecoder decoder, MessageEncoder encoder) {
        super(decoder, encoder);
    }

    @Override
    public boolean supports(InTransport transport) {
        if (transport instanceof HTTPInTransport) {
            HTTPInTransport t = (HTTPInTransport)transport;
            return t.getParameterValue("SAMLart") != null;
        }
        return false;
    }

    @Override
    public boolean supports(OutTransport transport) {
        return transport instanceof HTTPOutTransport;
    }

    @Override
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    @Override
    public void getSecurityPolicy(List<SecurityPolicyRule> securityPolicy, SAMLMessageContext samlContext) {
        SignatureTrustEngine engine = samlContext.getLocalTrustEngine();
        securityPolicy.add(new SAMLProtocolMessageXMLSignatureSecurityPolicyRule(engine));
    }
}

