/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml.metadata;

import java.util.Map;
import java.util.Set;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.AbstractMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sqsaml.org.springframework.security.saml.metadata.AbstractMetadataDelegate;
import sqsaml.org.springframework.security.saml.metadata.ExtendedMetadata;
import sqsaml.org.springframework.security.saml.metadata.ExtendedMetadataProvider;

public class ExtendedMetadataDelegate
extends AbstractMetadataDelegate
implements ExtendedMetadataProvider {
    protected final Logger log = LoggerFactory.getLogger(ExtendedMetadataDelegate.class);
    private boolean metadataRequireSignature = false;
    private boolean metadataTrustCheck = true;
    private boolean forceMetadataRevocationCheck = false;
    private Set<String> metadataTrustedKeys = null;
    private ExtendedMetadata defaultMetadata;
    private Map<String, ExtendedMetadata> extendedMetadataMap;
    private boolean trustFiltersInitialized;

    public ExtendedMetadataDelegate(MetadataProvider delegate) {
        this(delegate, null, null);
    }

    public ExtendedMetadataDelegate(MetadataProvider delegate, ExtendedMetadata defaultMetadata) {
        this(delegate, defaultMetadata, null);
    }

    public ExtendedMetadataDelegate(MetadataProvider delegate, Map<String, ExtendedMetadata> extendedMetadataMap) {
        this(delegate, null, extendedMetadataMap);
    }

    public ExtendedMetadataDelegate(MetadataProvider delegate, ExtendedMetadata defaultMetadata, Map<String, ExtendedMetadata> extendedMetadataMap) {
        super(delegate);
        this.defaultMetadata = defaultMetadata == null ? new ExtendedMetadata() : defaultMetadata;
        this.extendedMetadataMap = extendedMetadataMap;
    }

    @Override
    public ExtendedMetadata getExtendedMetadata(String entityID) throws MetadataProviderException {
        EntityDescriptor entityDescriptor = this.getEntityDescriptor(entityID);
        if (entityDescriptor == null) {
            return null;
        }
        ExtendedMetadata extendedMetadata = null;
        if (this.extendedMetadataMap != null) {
            extendedMetadata = this.extendedMetadataMap.get(entityID);
        }
        if (extendedMetadata == null) {
            return this.defaultMetadata;
        }
        return extendedMetadata;
    }

    public void initialize() throws MetadataProviderException {
        if (this.getDelegate() instanceof AbstractMetadataProvider) {
            this.log.debug("Initializing delegate");
            AbstractMetadataProvider provider = (AbstractMetadataProvider)this.getDelegate();
            provider.initialize();
        } else {
            this.log.debug("Cannot initialize delegate, doesn't extend AbstractMetadataProvider");
        }
    }

    public void destroy() {
        if (this.getDelegate() instanceof AbstractMetadataProvider) {
            this.log.debug("Destroying delegate");
            AbstractMetadataProvider provider = (AbstractMetadataProvider)this.getDelegate();
            provider.destroy();
        } else {
            this.log.debug("Cannot destroy delegate, doesn't extend AbstractMetadataProvider");
        }
    }

    public Set<String> getMetadataTrustedKeys() {
        return this.metadataTrustedKeys;
    }

    public void setMetadataTrustedKeys(Set<String> metadataTrustedKeys) {
        this.metadataTrustedKeys = metadataTrustedKeys;
    }

    public boolean isMetadataRequireSignature() {
        return this.metadataRequireSignature;
    }

    public void setMetadataRequireSignature(boolean metadataRequireSignature) {
        this.metadataRequireSignature = metadataRequireSignature;
    }

    public boolean isMetadataTrustCheck() {
        return this.metadataTrustCheck;
    }

    public void setMetadataTrustCheck(boolean metadataTrustCheck) {
        this.metadataTrustCheck = metadataTrustCheck;
    }

    public boolean isForceMetadataRevocationCheck() {
        return this.forceMetadataRevocationCheck;
    }

    public void setForceMetadataRevocationCheck(boolean forceMetadataRevocationCheck) {
        this.forceMetadataRevocationCheck = forceMetadataRevocationCheck;
    }

    protected boolean isTrustFiltersInitialized() {
        return this.trustFiltersInitialized;
    }

    protected void setTrustFiltersInitialized(boolean trustFiltersInitialized) {
        this.trustFiltersInitialized = trustFiltersInitialized;
    }

    public String toString() {
        return this.getDelegate().toString();
    }
}

