/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.NameID;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSString;
import sqsaml.org.springframework.security.saml.parser.SAMLCollection;
import sqsaml.org.springframework.security.saml.parser.SAMLObject;

public class SAMLCredential
implements Serializable {
    private SAMLObject<NameID> nameID;
    private SAMLObject<Assertion> authenticationAssertion;
    private String localEntityID;
    private String remoteEntityID;
    private String relayState;
    private Serializable additionalData;
    private SAMLCollection<Attribute> attributes;

    public SAMLCredential(NameID nameID, Assertion authenticationAssertion, String remoteEntityID, String localEntityID) {
        this(nameID, authenticationAssertion, remoteEntityID, Collections.emptyList(), localEntityID);
    }

    public SAMLCredential(NameID nameID, Assertion authenticationAssertion, String remoteEntityID, List<Attribute> attributes, String localEntityID) {
        this(nameID, authenticationAssertion, remoteEntityID, null, attributes, localEntityID);
    }

    public SAMLCredential(NameID nameID, Assertion authenticationAssertion, String remoteEntityID, String relayState, List<Attribute> attributes, String localEntityID) {
        this(nameID, authenticationAssertion, remoteEntityID, relayState, attributes, localEntityID, null);
    }

    public SAMLCredential(NameID nameID, Assertion authenticationAssertion, String remoteEntityID, String relayState, List<Attribute> attributes, String localEntityID, Serializable additionalData) {
        this.nameID = new SAMLObject<NameID>(nameID);
        this.authenticationAssertion = new SAMLObject<Assertion>(authenticationAssertion);
        this.remoteEntityID = remoteEntityID;
        this.relayState = relayState;
        this.attributes = new SAMLCollection<Attribute>(attributes);
        this.localEntityID = localEntityID;
        this.additionalData = additionalData;
    }

    public NameID getNameID() {
        return (NameID)this.nameID.getObject();
    }

    public Assertion getAuthenticationAssertion() {
        return (Assertion)this.authenticationAssertion.getObject();
    }

    public String getRemoteEntityID() {
        return this.remoteEntityID;
    }

    public Attribute getAttribute(String name) {
        for (Attribute attribute : this.getAttributes()) {
            if (!name.equalsIgnoreCase(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public String getAttributeAsString(String name) {
        Attribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return null;
        }
        List<XMLObject> attributeValues = attribute.getAttributeValues();
        if (attributeValues == null || attributeValues.size() == 0) {
            return null;
        }
        XMLObject xmlValue = attributeValues.iterator().next();
        return this.getString(xmlValue);
    }

    public String[] getAttributeAsStringArray(String name) {
        Attribute attribute = this.getAttribute(name);
        if (attribute == null) {
            return null;
        }
        List<XMLObject> attributeValues = attribute.getAttributeValues();
        if (attributeValues == null || attributeValues.size() == 0) {
            return new String[0];
        }
        String[] result = new String[attributeValues.size()];
        int i = 0;
        for (XMLObject attributeValue : attributeValues) {
            result[i++] = this.getString(attributeValue);
        }
        return result;
    }

    private String getString(XMLObject xmlValue) {
        if (xmlValue instanceof XSString) {
            return ((XSString)xmlValue).getValue();
        }
        if (xmlValue instanceof XSAny) {
            return ((XSAny)xmlValue).getTextContent();
        }
        return null;
    }

    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes.getObject());
    }

    public String getRelayState() {
        return this.relayState;
    }

    public String getLocalEntityID() {
        return this.localEntityID;
    }

    public Serializable getAdditionalData() {
        return this.additionalData;
    }
}

