/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.springframework.security.saml;

import org.opensaml.Configuration;
import org.opensaml.PaosBootstrap;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.security.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xml.security.x509.X509KeyInfoGeneratorFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class SAMLBootstrap
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            PaosBootstrap.bootstrap();
            this.setMetadataKeyInfoGenerator();
        }
        catch (ConfigurationException e) {
            throw new FatalBeanException("Error invoking OpenSAML bootstrap", (Throwable)e);
        }
    }

    protected void setMetadataKeyInfoGenerator() {
        NamedKeyInfoGeneratorManager manager = Configuration.getGlobalSecurityConfiguration().getKeyInfoGeneratorManager();
        X509KeyInfoGeneratorFactory generator = new X509KeyInfoGeneratorFactory();
        generator.setEmitEntityCertificate(true);
        generator.setEmitEntityCertificateChain(true);
        manager.registerFactory("MetadataKeyInfoGenerator", generator);
    }
}

