/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.waf.rules;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sqsaml.org.owasp.esapi.waf.actions.Action;
import sqsaml.org.owasp.esapi.waf.actions.BlockAction;
import sqsaml.org.owasp.esapi.waf.actions.DefaultAction;
import sqsaml.org.owasp.esapi.waf.actions.DoNothingAction;
import sqsaml.org.owasp.esapi.waf.configuration.AppGuardianConfiguration;
import sqsaml.org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import sqsaml.org.owasp.esapi.waf.rules.Rule;

public class RestrictUserAgentRule
extends Rule {
    private static final String USER_AGENT_HEADER = "User-Agent";
    private Pattern allow;
    private Pattern deny;

    public RestrictUserAgentRule(String id, Pattern allow, Pattern deny) {
        this.allow = allow;
        this.deny = deny;
        this.setId(id);
    }

    @Override
    public Action check(HttpServletRequest request, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        String userAgent = request.getHeader(USER_AGENT_HEADER);
        if (userAgent == null) {
            userAgent = "";
        }
        if (this.allow != null ? this.allow.matcher(userAgent).matches() : this.deny != null && !this.deny.matcher(userAgent).matches()) {
            return new DoNothingAction();
        }
        this.log(request, "Disallowed user agent pattern '" + this.deny.pattern() + "' found in user agent '" + request.getHeader(USER_AGENT_HEADER) + "'");
        if (AppGuardianConfiguration.DEFAULT_FAIL_ACTION == 1) {
            return new BlockAction();
        }
        return new DefaultAction();
    }
}

