/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.waf.rules;

import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sqsaml.org.owasp.esapi.waf.actions.Action;
import sqsaml.org.owasp.esapi.waf.actions.DefaultAction;
import sqsaml.org.owasp.esapi.waf.actions.DoNothingAction;
import sqsaml.org.owasp.esapi.waf.actions.RedirectAction;
import sqsaml.org.owasp.esapi.waf.internal.InterceptingHTTPServletResponse;
import sqsaml.org.owasp.esapi.waf.rules.Rule;

public class EnforceHTTPSRule
extends Rule {
    private Pattern path;
    private List<Object> exceptions;
    private String action;

    public EnforceHTTPSRule(String id, Pattern path, List<Object> exceptions, String action) {
        this.path = path;
        this.exceptions = exceptions;
        this.action = action;
        this.setId(id);
    }

    @Override
    public Action check(HttpServletRequest request, InterceptingHTTPServletResponse response, HttpServletResponse httpResponse) {
        if (!request.isSecure() && this.path.matcher(request.getRequestURI()).matches()) {
            for (Object o : this.exceptions) {
                if (!(o instanceof String ? ((String)o).equalsIgnoreCase(request.getRequestURI()) : o instanceof Pattern && ((Pattern)o).matcher(request.getRequestURI()).matches())) continue;
                return new DoNothingAction();
            }
            this.log(request, "Insecure request to resource detected in URL: '" + request.getRequestURL() + "'");
            if ("redirect".equals(this.action)) {
                RedirectAction ra = new RedirectAction();
                ra.setRedirectURL(request.getRequestURL().toString().replaceFirst("http", "https"));
                return ra;
            }
            return new DefaultAction();
        }
        return new DoNothingAction();
    }
}

