/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.reference.validation;

import sqsaml.org.owasp.esapi.Encoder;
import sqsaml.org.owasp.esapi.StringUtilities;
import sqsaml.org.owasp.esapi.errors.ValidationException;
import sqsaml.org.owasp.esapi.reference.validation.BaseValidationRule;

public class IntegerValidationRule
extends BaseValidationRule {
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;

    public IntegerValidationRule(String typeName, Encoder encoder) {
        super(typeName, encoder);
    }

    public IntegerValidationRule(String typeName, Encoder encoder, int minValue, int maxValue) {
        super(typeName, encoder);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public Integer getValid(String context, String input) throws ValidationException {
        return this.safelyParse(context, input);
    }

    private Integer safelyParse(String context, String input) throws ValidationException {
        if (input != null) {
            input = input.trim();
        }
        if (StringUtilities.isEmpty(input)) {
            if (this.allowNull) {
                return null;
            }
            throw new ValidationException(context + ": Input number required", "Input number required: context=" + context + ", input=" + input, context);
        }
        String canonical = this.encoder.canonicalize(input);
        if (this.minValue > this.maxValue) {
            throw new ValidationException(context + ": Invalid number input: context", "Validation parameter error for number: maxValue ( " + this.maxValue + ") must be greater than minValue ( " + this.minValue + ") for " + context, context);
        }
        try {
            int i = Integer.valueOf(canonical);
            if (i < this.minValue) {
                throw new ValidationException("Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context, "Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context + ", input=" + input, context);
            }
            if (i > this.maxValue) {
                throw new ValidationException("Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context, "Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context + ", input=" + input, context);
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new ValidationException(context + ": Invalid number input", "Invalid number input format: context=" + context + ", input=" + input, e, context);
        }
    }

    @Override
    public Integer sanitize(String context, String input) {
        Integer toReturn = 0;
        try {
            toReturn = this.safelyParse(context, input);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return toReturn;
    }
}

