/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.reference.validation;

import java.text.DateFormat;
import java.util.Date;
import sqsaml.org.owasp.esapi.ESAPI;
import sqsaml.org.owasp.esapi.Encoder;
import sqsaml.org.owasp.esapi.StringUtilities;
import sqsaml.org.owasp.esapi.ValidationErrorList;
import sqsaml.org.owasp.esapi.errors.ValidationException;
import sqsaml.org.owasp.esapi.reference.validation.BaseValidationRule;

public class DateValidationRule
extends BaseValidationRule {
    private DateFormat format = DateFormat.getDateInstance();

    public DateValidationRule(String typeName, Encoder encoder, DateFormat newFormat) {
        super(typeName, encoder);
        this.setDateFormat(newFormat);
    }

    public final void setDateFormat(DateFormat newFormat) {
        if (newFormat == null) {
            throw new IllegalArgumentException("DateValidationRule.setDateFormat requires a non-null DateFormat");
        }
        this.format = newFormat;
        this.format.setLenient(ESAPI.securityConfiguration().getLenientDatesAccepted());
    }

    @Override
    public Date getValid(String context, String input) throws ValidationException {
        return this.safelyParse(context, input, false);
    }

    @Override
    public Date sanitize(String context, String input) {
        return this.sanitize(context, input, null);
    }

    public Date sanitize(String context, String input, ValidationErrorList errorList) {
        Date date;
        block2: {
            date = new Date(0L);
            try {
                date = this.safelyParse(context, input, true);
            }
            catch (ValidationException e) {
                if (errorList == null) break block2;
                errorList.addError(context, e);
            }
        }
        return date;
    }

    private Date safelyParse(String context, String input, boolean sanitize) throws ValidationException {
        if (StringUtilities.isEmpty(input)) {
            if (this.allowNull) {
                return null;
            }
            throw new ValidationException(context + ": Input date required", "Input date required: context=" + context + ", input=" + input, context);
        }
        String canonical = this.encoder.canonicalize(input);
        try {
            String cycled;
            Date rval = this.format.parse(canonical);
            if (sanitize && !(cycled = this.format.format(rval)).equals(canonical)) {
                throw new Exception("Parameter date is not a clean translation between String and Date contexts.  Check input for additional characters");
            }
            return rval;
        }
        catch (Exception e) {
            throw new ValidationException(context + ": Invalid date must follow the " + this.format.getNumberFormat() + " format", "Invalid date: context=" + context + ", format=" + this.format + ", input=" + input, e, context);
        }
    }
}

