/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.reference;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.UUID;
import sqsaml.org.owasp.esapi.ESAPI;
import sqsaml.org.owasp.esapi.EncoderConstants;
import sqsaml.org.owasp.esapi.Logger;
import sqsaml.org.owasp.esapi.Randomizer;
import sqsaml.org.owasp.esapi.errors.EncryptionException;

public class DefaultRandomizer
implements Randomizer {
    private static volatile Randomizer singletonInstance;
    private SecureRandom secureRandom = null;
    private final Logger logger = ESAPI.getLogger("Randomizer");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Randomizer getInstance() {
        if (singletonInstance != null) return singletonInstance;
        Class<DefaultRandomizer> clazz = DefaultRandomizer.class;
        synchronized (DefaultRandomizer.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new DefaultRandomizer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    private DefaultRandomizer() {
        String algorithm = ESAPI.securityConfiguration().getRandomAlgorithm();
        try {
            this.secureRandom = SecureRandom.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            new EncryptionException("Error creating randomizer", "Can't find random algorithm " + algorithm, e);
        }
    }

    @Override
    public String getRandomString(int length, char[] characterSet) {
        StringBuilder sb = new StringBuilder();
        for (int loop = 0; loop < length; ++loop) {
            int index = this.secureRandom.nextInt(characterSet.length);
            sb.append(characterSet[index]);
        }
        String nonce = sb.toString();
        return nonce;
    }

    @Override
    public boolean getRandomBoolean() {
        return this.secureRandom.nextBoolean();
    }

    @Override
    public int getRandomInteger(int min, int max) {
        return this.secureRandom.nextInt(max - min) + min;
    }

    @Override
    public long getRandomLong() {
        return this.secureRandom.nextLong();
    }

    @Override
    public float getRandomReal(float min, float max) {
        float factor = max - min;
        return this.secureRandom.nextFloat() * factor + min;
    }

    @Override
    public String getRandomFilename(String extension) {
        String fn = this.getRandomString(12, EncoderConstants.CHAR_ALPHANUMERICS) + "." + extension;
        this.logger.debug(Logger.SECURITY_SUCCESS, "Generated new random filename: " + fn);
        return fn;
    }

    @Override
    public String getRandomGUID() throws EncryptionException {
        return UUID.randomUUID().toString();
    }

    @Override
    public byte[] getRandomBytes(int n) {
        byte[] result = new byte[n];
        this.secureRandom.nextBytes(result);
        return result;
    }
}

