/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.reference;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import sqsaml.org.owasp.esapi.AccessReferenceMap;
import sqsaml.org.owasp.esapi.errors.AccessControlException;

public abstract class AbstractAccessReferenceMap<K>
implements AccessReferenceMap<K> {
    private static final long serialVersionUID = 238742764284682230L;
    protected Map<K, Object> itod;
    protected Map<Object, K> dtoi;

    public AbstractAccessReferenceMap() {
        this.itod = new HashMap<K, Object>();
        this.dtoi = new HashMap<Object, K>();
    }

    public AbstractAccessReferenceMap(int initialSize) {
        this.itod = new HashMap<K, Object>(initialSize);
        this.dtoi = new HashMap<Object, K>(initialSize);
    }

    @Deprecated
    public AbstractAccessReferenceMap(Set<Object> directReferences) {
        this.itod = new HashMap<K, Object>(directReferences.size());
        this.dtoi = new HashMap<Object, K>(directReferences.size());
        this.update(directReferences);
    }

    @Deprecated
    public AbstractAccessReferenceMap(Set<Object> directReferences, int initialSize) {
        this.itod = new HashMap<K, Object>(initialSize);
        this.dtoi = new HashMap<Object, K>(initialSize);
        this.update(directReferences);
    }

    protected abstract K getUniqueReference();

    @Override
    public synchronized Iterator iterator() {
        TreeSet<Object> sorted = new TreeSet<Object>(this.dtoi.keySet());
        return sorted.iterator();
    }

    @Override
    public synchronized <T> K addDirectReference(T direct) {
        if (this.dtoi.keySet().contains(direct)) {
            return this.dtoi.get(direct);
        }
        K indirect = this.getUniqueReference();
        this.itod.put(indirect, direct);
        this.dtoi.put(direct, indirect);
        return indirect;
    }

    @Override
    public synchronized <T> K removeDirectReference(T direct) throws AccessControlException {
        K indirect = this.dtoi.get(direct);
        if (indirect != null) {
            this.itod.remove(indirect);
            this.dtoi.remove(direct);
        }
        return indirect;
    }

    @Override
    public final synchronized void update(Set directReferences) {
        K idCurrent;
        HashMap new_dtoi = new HashMap(directReferences.size());
        HashMap<K, Object> new_itod = new HashMap<K, Object>(directReferences.size());
        HashSet newDirect = new HashSet(directReferences);
        HashSet<Object> dtoiCurrent = new HashSet<Object>(this.dtoi.keySet());
        dtoiCurrent.retainAll(newDirect);
        for (Object e : dtoiCurrent) {
            idCurrent = this.dtoi.get(e);
            new_dtoi.put(e, idCurrent);
            new_itod.put(idCurrent, e);
        }
        newDirect.removeAll(dtoiCurrent);
        for (Object e : newDirect) {
            while (this.dtoi.containsValue(idCurrent = this.getUniqueReference())) {
            }
            new_dtoi.put(e, idCurrent);
            new_itod.put(idCurrent, e);
        }
        this.dtoi = new_dtoi;
        this.itod = new_itod;
    }

    @Override
    public synchronized <T> K getIndirectReference(T directReference) {
        return this.dtoi.get(directReference);
    }

    @Override
    public synchronized <T> T getDirectReference(K indirectReference) throws AccessControlException {
        if (this.itod.containsKey(indirectReference)) {
            try {
                return (T)this.itod.get(indirectReference);
            }
            catch (ClassCastException e) {
                throw new AccessControlException("Access denied.", "Request for incorrect type reference: " + indirectReference);
            }
        }
        throw new AccessControlException("Access denied", "Request for invalid indirect reference: " + indirectReference);
    }
}

