/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import sqsaml.org.owasp.esapi.ESAPI;
import sqsaml.org.owasp.esapi.Logger;
import sqsaml.org.owasp.esapi.crypto.CipherSpec;
import sqsaml.org.owasp.esapi.crypto.CipherText;
import sqsaml.org.owasp.esapi.crypto.CryptoHelper;
import sqsaml.org.owasp.esapi.errors.EncryptionException;
import sqsaml.org.owasp.esapi.util.ByteConversionUtil;

public class CipherTextSerializer {
    public static final int cipherTextSerializerVersion = 20130830;
    private static final long serialVersionUID = 20130830L;
    private static final Logger logger = ESAPI.getLogger("CipherTextSerializer");
    private CipherText cipherText_ = null;

    public CipherTextSerializer(CipherText cipherTextObj) {
        if (cipherTextObj == null) {
            throw new IllegalArgumentException("CipherText object must not be null.");
        }
        this.cipherText_ = cipherTextObj;
    }

    public CipherTextSerializer(byte[] cipherTextSerializedBytes) throws EncryptionException {
        this.cipherText_ = this.convertToCipherText(cipherTextSerializedBytes);
    }

    public byte[] asSerializedByteArray() {
        int kdfInfo = this.cipherText_.getKDFInfo();
        this.debug("asSerializedByteArray: kdfInfo = " + kdfInfo);
        long timestamp = this.cipherText_.getEncryptionTimestamp();
        String cipherXform = this.cipherText_.getCipherTransformation();
        if (this.cipherText_.getKeySize() >= Short.MAX_VALUE) {
            throw new IllegalArgumentException("Key size is too large. Max is 32767");
        }
        short keySize = (short)this.cipherText_.getKeySize();
        if (this.cipherText_.getBlockSize() >= Short.MAX_VALUE) {
            throw new IllegalArgumentException("Block size is too large. Max is 32767");
        }
        short blockSize = (short)this.cipherText_.getBlockSize();
        byte[] iv = this.cipherText_.getIV();
        if (iv.length >= Short.MAX_VALUE) {
            throw new IllegalArgumentException("IV size too large. Max is 32767 bytes");
        }
        short ivLen = (short)iv.length;
        byte[] rawCiphertext = this.cipherText_.getRawCipherText();
        int ciphertextLen = rawCiphertext.length;
        if (ciphertextLen < 1) {
            throw new IllegalArgumentException("Raw ciphertext length must be >= 1 byte.");
        }
        byte[] mac = this.cipherText_.getSeparateMAC();
        if (mac.length >= Short.MAX_VALUE) {
            throw new IllegalArgumentException("MAC length too large. Max is 32767 bytes");
        }
        short macLen = (short)mac.length;
        byte[] serializedObj = this.computeSerialization(kdfInfo, timestamp, cipherXform, keySize, blockSize, ivLen, iv, ciphertextLen, rawCiphertext, macLen, mac);
        return serializedObj;
    }

    public CipherText asCipherText() {
        if (this.cipherText_ == null) {
            throw new IllegalArgumentException("Program error? CipherText object, cipherText_, must not be null.");
        }
        return this.cipherText_;
    }

    private byte[] computeSerialization(int kdfInfo, long timestamp, String cipherXform, short keySize, short blockSize, short ivLen, byte[] iv, int ciphertextLen, byte[] rawCiphertext, short macLen, byte[] mac) {
        this.debug("computeSerialization: kdfInfo = " + kdfInfo);
        this.debug("computeSerialization: timestamp = " + new Date(timestamp));
        this.debug("computeSerialization: cipherXform = " + cipherXform);
        this.debug("computeSerialization: keySize = " + keySize);
        this.debug("computeSerialization: blockSize = " + blockSize);
        this.debug("computeSerialization: ivLen = " + ivLen);
        this.debug("computeSerialization: ciphertextLen = " + ciphertextLen);
        this.debug("computeSerialization: macLen = " + macLen);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeInt(baos, kdfInfo);
        this.writeLong(baos, timestamp);
        String[] parts = cipherXform.split("/");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Program error? Malformed cipher tranformation: " + cipherXform);
        }
        this.writeString(baos, cipherXform);
        this.writeShort(baos, keySize);
        this.writeShort(baos, blockSize);
        this.writeShort(baos, ivLen);
        if (ivLen > 0) {
            baos.write(iv, 0, iv.length);
        }
        this.writeInt(baos, ciphertextLen);
        baos.write(rawCiphertext, 0, rawCiphertext.length);
        this.writeShort(baos, macLen);
        if (macLen > 0) {
            baos.write(mac, 0, mac.length);
        }
        return baos.toByteArray();
    }

    private void writeString(ByteArrayOutputStream baos, String str) {
        try {
            if (str == null || str.length() == 0) {
                throw new IllegalArgumentException("Program error? writeString: str is null or empty!");
            }
            byte[] bytes = str.getBytes("UTF8");
            if (bytes.length >= Short.MAX_VALUE) {
                throw new IllegalArgumentException("Program error? writeString: String exceeds max length of 32767 bytes");
            }
            this.writeShort(baos, (short)bytes.length);
            baos.write(bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(Logger.EVENT_FAILURE, "Ignoring caught UnsupportedEncodingException converting string to UTF8 encoding. Results suspect. Corrupt rt.jar????");
        }
    }

    private String readString(ByteArrayInputStream bais, short sz) throws NullPointerException, IOException {
        byte[] bytes = new byte[sz];
        int ret = bais.read(bytes, 0, sz);
        if (ret != sz) {
            throw new IllegalArgumentException("Program error? readString: Expected to read " + sz + " bytes, but only read " + ret + " bytes");
        }
        return new String(bytes, "UTF8");
    }

    private void writeShort(ByteArrayOutputStream baos, short s) {
        byte[] shortAsByteArray = ByteConversionUtil.fromShort(s);
        if (shortAsByteArray.length != 2) {
            throw new IllegalArgumentException("Program error? writeShort: Excepted byte array != 2 bytes.");
        }
        baos.write(shortAsByteArray, 0, 2);
    }

    private short readShort(ByteArrayInputStream bais) throws NullPointerException, IndexOutOfBoundsException {
        byte[] shortAsByteArray = new byte[2];
        int ret = bais.read(shortAsByteArray, 0, 2);
        if (ret != 2) {
            throw new IllegalArgumentException("Program error? readShort: Failed to read 2 bytes.");
        }
        return ByteConversionUtil.toShort(shortAsByteArray);
    }

    private void writeInt(ByteArrayOutputStream baos, int i) {
        byte[] intAsByteArray = ByteConversionUtil.fromInt(i);
        baos.write(intAsByteArray, 0, 4);
    }

    private int readInt(ByteArrayInputStream bais) throws NullPointerException, IndexOutOfBoundsException {
        byte[] intAsByteArray = new byte[4];
        int ret = bais.read(intAsByteArray, 0, 4);
        if (ret != 4) {
            throw new IllegalArgumentException("Program error? readInt: Failed to read 4 bytes.");
        }
        return ByteConversionUtil.toInt(intAsByteArray);
    }

    private void writeLong(ByteArrayOutputStream baos, long l) {
        byte[] longAsByteArray = ByteConversionUtil.fromLong(l);
        if (longAsByteArray.length != 8) {
            throw new IllegalArgumentException("Program error? writeLong: Expected byte array != 8 bytes.");
        }
        baos.write(longAsByteArray, 0, 8);
    }

    private long readLong(ByteArrayInputStream bais) throws NullPointerException, IndexOutOfBoundsException {
        byte[] longAsByteArray = new byte[8];
        int ret = bais.read(longAsByteArray, 0, 8);
        if (ret != 8) {
            throw new IllegalArgumentException("Program error? readLong: Failed to read 8 bytes.");
        }
        return ByteConversionUtil.toLong(longAsByteArray);
    }

    private CipherText convertToCipherText(byte[] cipherTextSerializedBytes) throws EncryptionException {
        try {
            if (cipherTextSerializedBytes == null) {
                throw new IllegalArgumentException("cipherTextSerializedBytes cannot be null.");
            }
            if (cipherTextSerializedBytes.length == 0) {
                throw new IllegalArgumentException("cipherTextSerializedBytes must be > 0 in length.");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(cipherTextSerializedBytes);
            int kdfInfo = this.readInt(bais);
            this.debug("kdfInfo: " + kdfInfo);
            int kdfPrf = kdfInfo >>> 28;
            this.debug("kdfPrf: " + kdfPrf);
            if (kdfPrf < 0 || kdfPrf > 16) {
                throw new IllegalArgumentException("Program error? convertToCipherText: kdPrf is " + kdfPrf + ". Must be between 0 and 15 inclusive");
            }
            int kdfVers = kdfInfo & 0x7FFFFFF;
            if (!CryptoHelper.isValidKDFVersion(kdfVers, false, false)) {
                String logMsg = "KDF version read from serialized ciphertext (" + kdfVers + ") is out of range. Valid range for KDF version is [" + 20110203 + ", 99991231].";
                throw new EncryptionException("Version info from serialized ciphertext not in valid range.", "Likely tampering with KDF version on serialized ciphertext." + logMsg);
            }
            this.debug("convertToCipherText: kdfPrf = " + kdfPrf + ", kdfVers = " + kdfVers);
            if (!CipherTextSerializer.versionIsCompatible(kdfVers)) {
                throw new EncryptionException("This version of ESAPI is not compatible with the version of ESAPI that encrypted your data.", "KDF version " + kdfVers + " from serialized ciphertext not compatibile with current KDF version of " + 20130830);
            }
            long timestamp = this.readLong(bais);
            this.debug("convertToCipherText: timestamp = " + new Date(timestamp));
            short strSize = this.readShort(bais);
            this.debug("convertToCipherText: length of cipherXform = " + strSize);
            String cipherXform = this.readString(bais, strSize);
            this.debug("convertToCipherText: cipherXform = " + cipherXform);
            String[] parts = cipherXform.split("/");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Program error? Malformed cipher transformation. Expecting 3 parts to cipher transformation, alg/mode/padding, but found " + parts.length + " parts (" + cipherXform + ").");
            }
            String cipherMode = parts[1];
            if (!CryptoHelper.isAllowedCipherMode(cipherMode)) {
                String msg = "Cipher mode " + cipherMode + " is not an allowed cipher mode";
                throw new EncryptionException(msg, msg);
            }
            short keySize = this.readShort(bais);
            this.debug("convertToCipherText: keySize = " + keySize);
            short blockSize = this.readShort(bais);
            this.debug("convertToCipherText: blockSize = " + blockSize);
            short ivLen = this.readShort(bais);
            this.debug("convertToCipherText: ivLen = " + ivLen);
            byte[] iv = null;
            if (ivLen > 0) {
                iv = new byte[ivLen];
                bais.read(iv, 0, iv.length);
            }
            int ciphertextLen = this.readInt(bais);
            this.debug("convertToCipherText: ciphertextLen = " + ciphertextLen);
            if (ciphertextLen <= 0) {
                throw new IllegalArgumentException("convertToCipherText: Invalid cipher text length; must be > 0.");
            }
            byte[] rawCiphertext = new byte[ciphertextLen];
            bais.read(rawCiphertext, 0, rawCiphertext.length);
            short macLen = this.readShort(bais);
            this.debug("convertToCipherText: macLen = " + macLen);
            byte[] mac = null;
            if (macLen > 0) {
                mac = new byte[macLen];
                bais.read(mac, 0, mac.length);
            }
            CipherSpec cipherSpec = new CipherSpec(cipherXform, (int)keySize);
            cipherSpec.setBlockSize(blockSize);
            cipherSpec.setIV(iv);
            this.debug("convertToCipherText: CipherSpec: " + cipherSpec);
            CipherText ct = new CipherText(cipherSpec);
            if (ivLen <= 0 || !ct.requiresIV()) {
                throw new EncryptionException("convertToCipherText: Mismatch between IV length and cipher mode.", "Possible tampering of serialized ciphertext?");
            }
            ct.setCiphertext(rawCiphertext);
            ct.setEncryptionTimestamp(timestamp);
            if (macLen > 0) {
                ct.storeSeparateMAC(mac);
            }
            ct.setKDF_PRF(kdfPrf);
            ct.setKDFVersion(kdfVers);
            return ct;
        }
        catch (EncryptionException ex) {
            throw new EncryptionException("Cannot deserialize byte array into CipherText object", "Cannot deserialize byte array into CipherText object", ex);
        }
        catch (IOException e) {
            throw new EncryptionException("Cannot deserialize byte array into CipherText object", "Cannot deserialize byte array into CipherText object", e);
        }
    }

    private static boolean versionIsCompatible(int readKdfVers) {
        if (readKdfVers <= 0) {
            throw new IllegalArgumentException("Extracted KDF version is <= 0. Must be integer >= 1.");
        }
        switch (readKdfVers) {
            case 20110203: {
                return true;
            }
            case 20130830: {
                return true;
            }
        }
        return false;
    }

    private void debug(String msg) {
        if (logger.isDebugEnabled()) {
            logger.debug(Logger.EVENT_SUCCESS, msg);
        }
    }
}

