/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi.configuration;

import java.io.IOException;
import java.util.TreeSet;
import sqsaml.org.owasp.esapi.configuration.AbstractPrioritizedPropertyLoader;
import sqsaml.org.owasp.esapi.configuration.EsapiPropertyLoader;
import sqsaml.org.owasp.esapi.configuration.EsapiPropertyLoaderFactory;
import sqsaml.org.owasp.esapi.configuration.consts.EsapiConfiguration;
import sqsaml.org.owasp.esapi.errors.ConfigurationException;
import sqsaml.org.owasp.esapi.reference.DefaultSecurityConfiguration;

public class EsapiPropertyManager
implements EsapiPropertyLoader {
    protected TreeSet<AbstractPrioritizedPropertyLoader> loaders;

    public EsapiPropertyManager() throws IOException {
        this.initLoaders();
    }

    @Override
    public int getIntProp(String propertyName) throws ConfigurationException {
        for (AbstractPrioritizedPropertyLoader loader : this.loaders) {
            try {
                return loader.getIntProp(propertyName);
            }
            catch (ConfigurationException e) {
                DefaultSecurityConfiguration.logToStdout("Integer property '" + propertyName + "' not found in " + loader.name(), e);
            }
        }
        throw new ConfigurationException("Could not find property " + propertyName + " in configuration");
    }

    @Override
    public byte[] getByteArrayProp(String propertyName) throws ConfigurationException {
        for (AbstractPrioritizedPropertyLoader loader : this.loaders) {
            try {
                return loader.getByteArrayProp(propertyName);
            }
            catch (ConfigurationException e) {
                DefaultSecurityConfiguration.logToStdout("Byte array property '" + propertyName + "' not found in " + loader.name(), e);
            }
        }
        throw new ConfigurationException("Could not find property " + propertyName + " in configuration");
    }

    @Override
    public Boolean getBooleanProp(String propertyName) throws ConfigurationException {
        for (AbstractPrioritizedPropertyLoader loader : this.loaders) {
            try {
                return loader.getBooleanProp(propertyName);
            }
            catch (ConfigurationException e) {
                DefaultSecurityConfiguration.logToStdout("Boolean property '" + propertyName + "' not found in " + loader.name(), e);
            }
        }
        throw new ConfigurationException("Could not find property " + propertyName + " in configuration");
    }

    @Override
    public String getStringProp(String propertyName) throws ConfigurationException {
        for (AbstractPrioritizedPropertyLoader loader : this.loaders) {
            try {
                return loader.getStringProp(propertyName);
            }
            catch (ConfigurationException e) {
                DefaultSecurityConfiguration.logToStdout("Property '" + propertyName + "' not found in " + loader.name(), e);
            }
        }
        throw new ConfigurationException("Could not find property " + propertyName + " in configuration");
    }

    private void initLoaders() throws IOException {
        String msg;
        AbstractPrioritizedPropertyLoader appl;
        this.loaders = new TreeSet();
        try {
            appl = EsapiPropertyLoaderFactory.createPropertyLoader(EsapiConfiguration.OPSTEAM_ESAPI_CFG);
            if (appl == null) {
                msg = "WARNING: System property [" + EsapiConfiguration.OPSTEAM_ESAPI_CFG.getConfigName() + "] is not set";
                DefaultSecurityConfiguration.logToStdout(msg, null);
            } else {
                this.loaders.add(appl);
            }
        }
        catch (IOException e) {
            DefaultSecurityConfiguration.logToStdout("WARNING: Exception encountered while setting up ESAPI configuration manager for OPS team", e);
            throw e;
        }
        try {
            appl = EsapiPropertyLoaderFactory.createPropertyLoader(EsapiConfiguration.DEVTEAM_ESAPI_CFG);
            if (appl == null) {
                msg = "WARNING: System property [" + EsapiConfiguration.DEVTEAM_ESAPI_CFG.getConfigName() + "] is not set";
                DefaultSecurityConfiguration.logToStdout(msg, null);
            } else {
                this.loaders.add(appl);
            }
        }
        catch (IOException e) {
            DefaultSecurityConfiguration.logToStdout("WARNING: Exception encountered while setting up ESAPI configuration manager for DEV team", e);
            throw e;
        }
    }
}

