/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.owasp.esapi;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import sqsaml.org.owasp.esapi.Logger;
import sqsaml.org.owasp.esapi.errors.AccessControlException;
import sqsaml.org.owasp.esapi.errors.AuthenticationException;
import sqsaml.org.owasp.esapi.errors.EncryptionException;
import sqsaml.org.owasp.esapi.errors.IntrusionException;
import sqsaml.org.owasp.esapi.errors.ValidationException;

public interface HTTPUtilities {
    public static final String REMEMBER_TOKEN_COOKIE_NAME = "rtoken";
    public static final int MAX_COOKIE_LEN = 4096;
    public static final int MAX_COOKIE_PAIRS = 20;
    public static final String CSRF_TOKEN_NAME = "ctoken";
    public static final String ESAPI_STATE = "estate";
    public static final int PARAMETER = 0;
    public static final int HEADER = 1;
    public static final int COOKIE = 2;

    public void addCookie(Cookie var1);

    public void addCookie(HttpServletResponse var1, Cookie var2);

    public String addCSRFToken(String var1);

    public void addHeader(String var1, String var2);

    public void addHeader(HttpServletResponse var1, String var2, String var3);

    public void assertSecureRequest() throws AccessControlException;

    public void assertSecureChannel() throws AccessControlException;

    public void assertSecureRequest(HttpServletRequest var1) throws AccessControlException;

    public void assertSecureChannel(HttpServletRequest var1) throws AccessControlException;

    public HttpSession changeSessionIdentifier() throws AuthenticationException;

    public HttpSession changeSessionIdentifier(HttpServletRequest var1) throws AuthenticationException;

    public void clearCurrent();

    public String decryptHiddenField(String var1);

    public Map<String, String> decryptQueryString(String var1) throws EncryptionException;

    public Map<String, String> decryptStateFromCookie() throws EncryptionException;

    public Map<String, String> decryptStateFromCookie(HttpServletRequest var1) throws EncryptionException;

    public String encryptHiddenField(String var1) throws EncryptionException;

    public String encryptQueryString(String var1) throws EncryptionException;

    public void encryptStateInCookie(Map<String, String> var1) throws EncryptionException;

    public void encryptStateInCookie(HttpServletResponse var1, Map<String, String> var2) throws EncryptionException;

    public String getCookie(String var1) throws ValidationException;

    public String getCookie(HttpServletRequest var1, String var2) throws ValidationException;

    public String getCSRFToken();

    public HttpServletRequest getCurrentRequest();

    public HttpServletResponse getCurrentResponse();

    public List getFileUploads() throws ValidationException;

    public List getFileUploads(HttpServletRequest var1) throws ValidationException;

    public List getFileUploads(HttpServletRequest var1, File var2) throws ValidationException;

    public List getFileUploads(HttpServletRequest var1, File var2, List var3) throws ValidationException;

    public String getHeader(String var1) throws ValidationException;

    public String getHeader(HttpServletRequest var1, String var2) throws ValidationException;

    public String getParameter(String var1) throws ValidationException;

    public String getParameter(HttpServletRequest var1, String var2) throws ValidationException;

    public void killAllCookies();

    public void killAllCookies(HttpServletRequest var1, HttpServletResponse var2);

    public void killCookie(String var1);

    public void killCookie(HttpServletRequest var1, HttpServletResponse var2, String var3);

    public void logHTTPRequest();

    public void logHTTPRequest(HttpServletRequest var1, Logger var2);

    public void logHTTPRequest(HttpServletRequest var1, Logger var2, List var3);

    public void sendForward(String var1) throws AccessControlException, ServletException, IOException;

    public void sendForward(HttpServletRequest var1, HttpServletResponse var2, String var3) throws AccessControlException, ServletException, IOException;

    public void sendRedirect(String var1) throws AccessControlException, IOException;

    public void sendRedirect(HttpServletResponse var1, String var2) throws AccessControlException, IOException;

    public void setContentType();

    public void setContentType(HttpServletResponse var1);

    public void setCurrentHTTP(HttpServletRequest var1, HttpServletResponse var2);

    public void setHeader(String var1, String var2);

    public void setHeader(HttpServletResponse var1, String var2, String var3);

    public void setNoCacheHeaders();

    public void setNoCacheHeaders(HttpServletResponse var1);

    @Deprecated
    public String setRememberToken(String var1, int var2, String var3, String var4);

    public String setRememberToken(HttpServletRequest var1, HttpServletResponse var2, int var3, String var4, String var5);

    @Deprecated
    public String setRememberToken(HttpServletRequest var1, HttpServletResponse var2, String var3, int var4, String var5, String var6);

    public void verifyCSRFToken();

    public void verifyCSRFToken(HttpServletRequest var1) throws IntrusionException;

    public <T> T getSessionAttribute(String var1);

    public <T> T getSessionAttribute(HttpSession var1, String var2);

    public <T> T getRequestAttribute(String var1);

    public <T> T getRequestAttribute(HttpServletRequest var1, String var2);
}

