/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.pqc.jcajce.provider.saber;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import sqsaml.org.bouncycastle.crypto.CryptoServicesRegistrar;
import sqsaml.org.bouncycastle.pqc.crypto.saber.SABERKeyGenerationParameters;
import sqsaml.org.bouncycastle.pqc.crypto.saber.SABERKeyPairGenerator;
import sqsaml.org.bouncycastle.pqc.crypto.saber.SABERParameters;
import sqsaml.org.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import sqsaml.org.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.saber.BCSABERPrivateKey;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.saber.BCSABERPublicKey;
import sqsaml.org.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import sqsaml.org.bouncycastle.pqc.jcajce.spec.SABERParameterSpec;
import sqsaml.org.bouncycastle.util.Strings;

public class SABERKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    SABERKeyGenerationParameters param;
    SABERKeyPairGenerator engine = new SABERKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public SABERKeyPairGeneratorSpi() {
        super("SABER");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        String string = SABERKeyPairGeneratorSpi.getNameFromParams(algorithmParameterSpec);
        if (string == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + algorithmParameterSpec);
        }
        this.param = new SABERKeyGenerationParameters(secureRandom, (SABERParameters)parameters.get(string));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof SABERParameterSpec) {
            SABERParameterSpec sABERParameterSpec = (SABERParameterSpec)algorithmParameterSpec;
            return sABERParameterSpec.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(algorithmParameterSpec));
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new SABERKeyGenerationParameters(this.random, SABERParameters.firesaberkem256r3);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        SABERPublicKeyParameters sABERPublicKeyParameters = (SABERPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        SABERPrivateKeyParameters sABERPrivateKeyParameters = (SABERPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCSABERPublicKey(sABERPublicKeyParameters), new BCSABERPrivateKey(sABERPrivateKeyParameters));
    }

    static {
        parameters.put(SABERParameterSpec.lightsaberkem128r3.getName(), SABERParameters.lightsaberkem128r3);
        parameters.put(SABERParameterSpec.saberkem128r3.getName(), SABERParameters.saberkem128r3);
        parameters.put(SABERParameterSpec.firesaberkem128r3.getName(), SABERParameters.firesaberkem128r3);
        parameters.put(SABERParameterSpec.lightsaberkem192r3.getName(), SABERParameters.lightsaberkem192r3);
        parameters.put(SABERParameterSpec.saberkem192r3.getName(), SABERParameters.saberkem192r3);
        parameters.put(SABERParameterSpec.firesaberkem192r3.getName(), SABERParameters.firesaberkem192r3);
        parameters.put(SABERParameterSpec.lightsaberkem256r3.getName(), SABERParameters.lightsaberkem256r3);
        parameters.put(SABERParameterSpec.saberkem256r3.getName(), SABERParameters.saberkem256r3);
        parameters.put(SABERParameterSpec.firesaberkem256r3.getName(), SABERParameters.firesaberkem256r3);
    }
}

