/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.pqc.crypto.qteslarnd1;

import java.security.SecureRandom;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import sqsaml.org.bouncycastle.crypto.KeyGenerationParameters;
import sqsaml.org.bouncycastle.pqc.crypto.qteslarnd1.QTESLA;
import sqsaml.org.bouncycastle.pqc.crypto.qteslarnd1.QTESLAKeyGenerationParameters;
import sqsaml.org.bouncycastle.pqc.crypto.qteslarnd1.QTESLAPrivateKeyParameters;
import sqsaml.org.bouncycastle.pqc.crypto.qteslarnd1.QTESLAPublicKeyParameters;
import sqsaml.org.bouncycastle.pqc.crypto.qteslarnd1.QTESLASecurityCategory;

public final class QTESLAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private int securityCategory;
    private SecureRandom secureRandom;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        QTESLAKeyGenerationParameters qTESLAKeyGenerationParameters = (QTESLAKeyGenerationParameters)keyGenerationParameters;
        this.secureRandom = qTESLAKeyGenerationParameters.getRandom();
        this.securityCategory = qTESLAKeyGenerationParameters.getSecurityCategory();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        byte[] byArray = this.allocatePrivate(this.securityCategory);
        byte[] byArray2 = this.allocatePublic(this.securityCategory);
        switch (this.securityCategory) {
            case 0: {
                QTESLA.generateKeyPairI(byArray2, byArray, this.secureRandom);
                break;
            }
            case 1: {
                QTESLA.generateKeyPairIIISize(byArray2, byArray, this.secureRandom);
                break;
            }
            case 2: {
                QTESLA.generateKeyPairIIISpeed(byArray2, byArray, this.secureRandom);
                break;
            }
            case 3: {
                QTESLA.generateKeyPairIP(byArray2, byArray, this.secureRandom);
                break;
            }
            case 4: {
                QTESLA.generateKeyPairIIIP(byArray2, byArray, this.secureRandom);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.securityCategory);
            }
        }
        return new AsymmetricCipherKeyPair(new QTESLAPublicKeyParameters(this.securityCategory, byArray2), new QTESLAPrivateKeyParameters(this.securityCategory, byArray));
    }

    private byte[] allocatePrivate(int n) {
        return new byte[QTESLASecurityCategory.getPrivateSize(n)];
    }

    private byte[] allocatePublic(int n) {
        return new byte[QTESLASecurityCategory.getPublicSize(n)];
    }
}

