/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.operator.bc;

import java.io.IOException;
import sqsaml.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import sqsaml.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import sqsaml.org.bouncycastle.crypto.ExtendedDigest;
import sqsaml.org.bouncycastle.crypto.Signer;
import sqsaml.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import sqsaml.org.bouncycastle.crypto.signers.DSADigestSigner;
import sqsaml.org.bouncycastle.crypto.signers.DSASigner;
import sqsaml.org.bouncycastle.crypto.util.PublicKeyFactory;
import sqsaml.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import sqsaml.org.bouncycastle.operator.OperatorCreationException;
import sqsaml.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;

public class BcDSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcDSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new DSADigestSigner(new DSASigner(), extendedDigest);
    }

    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

