/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.crypto.tls;

import java.io.IOException;
import sqsaml.org.bouncycastle.crypto.tls.AbstractTlsClient;
import sqsaml.org.bouncycastle.crypto.tls.DefaultTlsCipherFactory;
import sqsaml.org.bouncycastle.crypto.tls.DefaultTlsDHVerifier;
import sqsaml.org.bouncycastle.crypto.tls.TlsAuthentication;
import sqsaml.org.bouncycastle.crypto.tls.TlsCipherFactory;
import sqsaml.org.bouncycastle.crypto.tls.TlsDHVerifier;
import sqsaml.org.bouncycastle.crypto.tls.TlsFatalAlert;
import sqsaml.org.bouncycastle.crypto.tls.TlsKeyExchange;
import sqsaml.org.bouncycastle.crypto.tls.TlsPSKIdentity;
import sqsaml.org.bouncycastle.crypto.tls.TlsPSKKeyExchange;
import sqsaml.org.bouncycastle.crypto.tls.TlsUtils;

public class PSKTlsClient
extends AbstractTlsClient {
    protected TlsDHVerifier dhVerifier;
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity tlsPSKIdentity) {
        this(new DefaultTlsCipherFactory(), tlsPSKIdentity);
    }

    public PSKTlsClient(TlsCipherFactory tlsCipherFactory, TlsPSKIdentity tlsPSKIdentity) {
        this(tlsCipherFactory, new DefaultTlsDHVerifier(), tlsPSKIdentity);
    }

    public PSKTlsClient(TlsCipherFactory tlsCipherFactory, TlsDHVerifier tlsDHVerifier, TlsPSKIdentity tlsPSKIdentity) {
        super(tlsCipherFactory);
        this.dhVerifier = tlsDHVerifier;
        this.pskIdentity = tlsPSKIdentity;
    }

    public int[] getCipherSuites() {
        return new int[]{49207, 49205};
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(n);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int n) {
        return new TlsPSKKeyExchange(n, this.supportedSignatureAlgorithms, this.pskIdentity, null, this.dhVerifier, null, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

