/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import sqsaml.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import sqsaml.org.bouncycastle.crypto.KeyGenerationParameters;
import sqsaml.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import sqsaml.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import sqsaml.org.bouncycastle.crypto.params.DHParameters;
import sqsaml.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import sqsaml.org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

