/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.asn1.x9;

import java.util.Enumeration;
import java.util.Vector;
import sqsaml.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import sqsaml.org.bouncycastle.asn1.anssi.ANSSINamedCurves;
import sqsaml.org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import sqsaml.org.bouncycastle.asn1.gm.GMNamedCurves;
import sqsaml.org.bouncycastle.asn1.nist.NISTNamedCurves;
import sqsaml.org.bouncycastle.asn1.sec.SECNamedCurves;
import sqsaml.org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import sqsaml.org.bouncycastle.asn1.x9.X962NamedCurves;
import sqsaml.org.bouncycastle.asn1.x9.X9ECParameters;
import sqsaml.org.bouncycastle.asn1.x9.X9ECParametersHolder;
import sqsaml.org.bouncycastle.crypto.ec.CustomNamedCurves;
import sqsaml.org.bouncycastle.internal.asn1.cryptlib.CryptlibObjectIdentifiers;

public class ECNamedCurveTable {
    public static X9ECParameters getByName(String string) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByName(string);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByName(string);
        }
        if (x9ECParameters == null) {
            x9ECParameters = NISTNamedCurves.getByName(string);
        }
        if (x9ECParameters == null) {
            x9ECParameters = TeleTrusTNamedCurves.getByName(string);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ANSSINamedCurves.getByName(string);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ECGOST3410NamedCurves.getByNameX9((String)string);
        }
        if (x9ECParameters == null) {
            x9ECParameters = GMNamedCurves.getByName(string);
        }
        return x9ECParameters;
    }

    public static X9ECParametersHolder getByNameLazy(String string) {
        X9ECParametersHolder x9ECParametersHolder = X962NamedCurves.getByNameLazy((String)string);
        if (null == x9ECParametersHolder) {
            x9ECParametersHolder = SECNamedCurves.getByNameLazy((String)string);
        }
        if (null == x9ECParametersHolder) {
            x9ECParametersHolder = NISTNamedCurves.getByNameLazy((String)string);
        }
        if (null == x9ECParametersHolder) {
            x9ECParametersHolder = TeleTrusTNamedCurves.getByNameLazy((String)string);
        }
        if (null == x9ECParametersHolder) {
            x9ECParametersHolder = ANSSINamedCurves.getByNameLazy((String)string);
        }
        if (null == x9ECParametersHolder) {
            x9ECParametersHolder = ECGOST3410NamedCurves.getByNameLazy((String)string);
        }
        if (null == x9ECParametersHolder) {
            x9ECParametersHolder = GMNamedCurves.getByNameLazy((String)string);
        }
        return x9ECParametersHolder;
    }

    public static ASN1ObjectIdentifier getOID(String string) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = X962NamedCurves.getOID(string);
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = SECNamedCurves.getOID(string);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = NISTNamedCurves.getOID(string);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = TeleTrusTNamedCurves.getOID(string);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = ANSSINamedCurves.getOID(string);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = ECGOST3410NamedCurves.getOID(string);
        }
        if (aSN1ObjectIdentifier == null) {
            aSN1ObjectIdentifier = GMNamedCurves.getOID(string);
        }
        if (aSN1ObjectIdentifier == null && string.equals("curve25519")) {
            aSN1ObjectIdentifier = CryptlibObjectIdentifiers.curvey25519;
        }
        return aSN1ObjectIdentifier;
    }

    public static String getName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string = X962NamedCurves.getName(aSN1ObjectIdentifier);
        if (string == null) {
            string = SECNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = NISTNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = TeleTrusTNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = ANSSINamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = ECGOST3410NamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = GMNamedCurves.getName(aSN1ObjectIdentifier);
        }
        if (string == null) {
            string = CustomNamedCurves.getName(aSN1ObjectIdentifier);
        }
        return string;
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(aSN1ObjectIdentifier);
        if (x9ECParameters == null) {
            x9ECParameters = SECNamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = TeleTrusTNamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ANSSINamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = ECGOST3410NamedCurves.getByOIDX9((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (x9ECParameters == null) {
            x9ECParameters = GMNamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    public static X9ECParametersHolder getByOIDLazy(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParametersHolder x9ECParametersHolder = X962NamedCurves.getByOIDLazy((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        if (null == x9ECParametersHolder) {
            x9ECParametersHolder = SECNamedCurves.getByOIDLazy((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (null == x9ECParametersHolder) {
            x9ECParametersHolder = TeleTrusTNamedCurves.getByOIDLazy((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (null == x9ECParametersHolder) {
            x9ECParametersHolder = ANSSINamedCurves.getByOIDLazy((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (null == x9ECParametersHolder) {
            x9ECParametersHolder = ECGOST3410NamedCurves.getByOIDLazy((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        if (null == x9ECParametersHolder) {
            x9ECParametersHolder = GMNamedCurves.getByOIDLazy((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
        }
        return x9ECParametersHolder;
    }

    public static Enumeration getNames() {
        Vector vector = new Vector();
        ECNamedCurveTable.addEnumeration(vector, X962NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, SECNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, NISTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, TeleTrusTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, ANSSINamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, ECGOST3410NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(vector, GMNamedCurves.getNames());
        return vector.elements();
    }

    private static void addEnumeration(Vector vector, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
    }
}

