/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.bouncycastle.asn1.pkcs;

import sqsaml.org.bouncycastle.asn1.ASN1Encodable;
import sqsaml.org.bouncycastle.asn1.ASN1EncodableVector;
import sqsaml.org.bouncycastle.asn1.ASN1Object;
import sqsaml.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import sqsaml.org.bouncycastle.asn1.ASN1Primitive;
import sqsaml.org.bouncycastle.asn1.ASN1Sequence;
import sqsaml.org.bouncycastle.asn1.ASN1Set;
import sqsaml.org.bouncycastle.asn1.DERSequence;

public class Attribute
extends ASN1Object {
    private ASN1ObjectIdentifier attrType;
    private ASN1Set attrValues;

    public static Attribute getInstance(Object object) {
        if (object == null || object instanceof Attribute) {
            return (Attribute)object;
        }
        if (object instanceof ASN1Sequence) {
            return new Attribute((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public Attribute(ASN1Sequence aSN1Sequence) {
        this.attrType = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
        this.attrValues = (ASN1Set)aSN1Sequence.getObjectAt(1);
    }

    public Attribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Set aSN1Set) {
        this.attrType = aSN1ObjectIdentifier;
        this.attrValues = aSN1Set;
    }

    public ASN1ObjectIdentifier getAttrType() {
        return this.attrType;
    }

    public ASN1Set getAttrValues() {
        return this.attrValues;
    }

    public ASN1Encodable[] getAttributeValues() {
        return this.attrValues.toArray();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.attrType);
        aSN1EncodableVector.add(this.attrValues);
        return new DERSequence(aSN1EncodableVector);
    }
}

