/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.utils.resolver.implementations;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import sqsaml.org.apache.xml.security.signature.XMLSignatureFileInput;
import sqsaml.org.apache.xml.security.signature.XMLSignatureInput;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverContext;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverException;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverSpi;

public class ResolverLocalFilesystem
extends ResourceResolverSpi {
    private static final System.Logger LOG = System.getLogger(ResolverLocalFilesystem.class.getName());

    @Override
    public XMLSignatureInput engineResolveURI(ResourceResolverContext context) throws ResourceResolverException {
        try {
            URI uriNew = ResolverLocalFilesystem.getNewURI(context.uriToResolve, context.baseUri);
            XMLSignatureFileInput result = new XMLSignatureFileInput(Paths.get(uriNew));
            result.setSecureValidation(context.secureValidation);
            result.setSourceURI(uriNew.toString());
            return result;
        }
        catch (Exception e) {
            throw new ResourceResolverException(e, context.uriToResolve, context.baseUri, "generic.EmptyMessage");
        }
    }

    @Override
    public boolean engineCanResolveURI(ResourceResolverContext context) {
        if (context.uriToResolve == null) {
            return false;
        }
        if (context.uriToResolve.isEmpty() || context.uriToResolve.charAt(0) == '#' || context.uriToResolve.startsWith("http:")) {
            return false;
        }
        try {
            LOG.log(System.Logger.Level.DEBUG, "I was asked whether I can resolve {0}", context.uriToResolve);
            if (context.uriToResolve.startsWith("file:") || context.baseUri.startsWith("file:")) {
                LOG.log(System.Logger.Level.DEBUG, "I state that I can resolve {0}", context.uriToResolve);
                return true;
            }
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.DEBUG, e.getMessage(), (Throwable)e);
        }
        LOG.log(System.Logger.Level.DEBUG, "But I can't");
        return false;
    }

    private static URI getNewURI(String uri, String baseURI) throws URISyntaxException {
        URI newUri = null;
        newUri = baseURI == null || baseURI.length() == 0 ? new URI(uri) : new URI(baseURI).resolve(uri);
        if (newUri.getFragment() != null) {
            return new URI(newUri.getScheme(), newUri.getSchemeSpecificPart(), null);
        }
        return newUri;
    }
}

