/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.stax.ext;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import sqsaml.org.apache.xml.security.stax.ext.InboundSecurityContext;
import sqsaml.org.apache.xml.security.stax.ext.InputProcessor;
import sqsaml.org.apache.xml.security.stax.ext.XMLSecurityProperties;
import sqsaml.org.apache.xml.security.stax.impl.DocumentContextImpl;
import sqsaml.org.apache.xml.security.stax.impl.InboundSecurityContextImpl;
import sqsaml.org.apache.xml.security.stax.impl.InputProcessorChainImpl;
import sqsaml.org.apache.xml.security.stax.impl.XMLSecurityStreamReader;
import sqsaml.org.apache.xml.security.stax.impl.processor.input.LogInputProcessor;
import sqsaml.org.apache.xml.security.stax.impl.processor.input.XMLEventReaderInputProcessor;
import sqsaml.org.apache.xml.security.stax.impl.processor.input.XMLSecurityInputProcessor;
import sqsaml.org.apache.xml.security.stax.securityEvent.SecurityEvent;
import sqsaml.org.apache.xml.security.stax.securityEvent.SecurityEventListener;

public class InboundXMLSec {
    private static final System.Logger LOG = System.getLogger(InboundXMLSec.class.getName());
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private final XMLSecurityProperties securityProperties;

    public InboundXMLSec(XMLSecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    public XMLStreamReader processInMessage(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        return this.processInMessage(xmlStreamReader, null, null);
    }

    public XMLStreamReader processInMessage(XMLStreamReader xmlStreamReader, List<SecurityEvent> requestSecurityEvents, SecurityEventListener securityEventListener) throws XMLStreamException {
        if (requestSecurityEvents == null) {
            requestSecurityEvents = Collections.emptyList();
        }
        InboundSecurityContextImpl inboundSecurityContext = new InboundSecurityContextImpl();
        inboundSecurityContext.putList(SecurityEvent.class, requestSecurityEvents);
        inboundSecurityContext.addSecurityEventListener(securityEventListener);
        inboundSecurityContext.put("XMLInputFactory", xmlInputFactory);
        DocumentContextImpl documentContext = new DocumentContextImpl();
        documentContext.setEncoding(xmlStreamReader.getEncoding() != null ? xmlStreamReader.getEncoding() : StandardCharsets.UTF_8.name());
        Location location = xmlStreamReader.getLocation();
        if (location != null) {
            documentContext.setBaseURI(location.getSystemId());
        }
        InputProcessorChainImpl inputProcessorChain = new InputProcessorChainImpl((InboundSecurityContext)inboundSecurityContext, documentContext);
        inputProcessorChain.addProcessor(new XMLEventReaderInputProcessor(this.securityProperties, xmlStreamReader));
        List<InputProcessor> additionalInputProcessors = this.securityProperties.getInputProcessorList();
        if (!additionalInputProcessors.isEmpty()) {
            for (InputProcessor inputProcessor : additionalInputProcessors) {
                inputProcessorChain.addProcessor(inputProcessor);
            }
        }
        inputProcessorChain.addProcessor(new XMLSecurityInputProcessor(this.securityProperties));
        if (LOG.isLoggable(System.Logger.Level.TRACE)) {
            LogInputProcessor logInputProcessor = new LogInputProcessor(this.securityProperties);
            logInputProcessor.addAfterProcessor(XMLSecurityInputProcessor.class.getName());
            inputProcessorChain.addProcessor(logInputProcessor);
        }
        return new XMLSecurityStreamReader(inputProcessorChain, this.securityProperties);
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        try {
            xmlInputFactory.setProperty("org.codehaus.stax2.internNames", true);
            xmlInputFactory.setProperty("org.codehaus.stax2.internNsUris", true);
            xmlInputFactory.setProperty("org.codehaus.stax2.preserveLocation", false);
        }
        catch (IllegalArgumentException e) {
            LOG.log(System.Logger.Level.DEBUG, e.getMessage(), (Throwable)e);
        }
    }
}

