/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.xml.security.encryption;

import java.io.IOException;
import org.w3c.dom.Attr;
import sqsaml.org.apache.xml.security.c14n.CanonicalizationException;
import sqsaml.org.apache.xml.security.encryption.CipherData;
import sqsaml.org.apache.xml.security.encryption.CipherReference;
import sqsaml.org.apache.xml.security.encryption.EncryptedType;
import sqsaml.org.apache.xml.security.encryption.Transforms;
import sqsaml.org.apache.xml.security.encryption.XMLEncryptionException;
import sqsaml.org.apache.xml.security.signature.XMLSignatureInput;
import sqsaml.org.apache.xml.security.transforms.TransformationException;
import sqsaml.org.apache.xml.security.utils.XMLUtils;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolver;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverContext;
import sqsaml.org.apache.xml.security.utils.resolver.ResourceResolverException;

public class XMLCipherInput {
    private static final System.Logger LOG = System.getLogger(XMLCipherInput.class.getName());
    private CipherData cipherData;
    private boolean secureValidation = true;

    public XMLCipherInput(CipherData data) throws XMLEncryptionException {
        this.cipherData = data;
        if (this.cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public XMLCipherInput(EncryptedType input) throws XMLEncryptionException {
        this(input == null ? null : input.getCipherData());
    }

    public void setSecureValidation(boolean secureValidation) {
        this.secureValidation = secureValidation;
    }

    public byte[] getBytes() throws XMLEncryptionException {
        return this.getDecryptBytes();
    }

    private byte[] getDecryptBytes() throws XMLEncryptionException {
        String base64EncodedEncryptedOctets = null;
        if (this.cipherData.getDataType() == 2) {
            LOG.log(System.Logger.Level.DEBUG, "Found a reference type CipherData");
            CipherReference cr = this.cipherData.getCipherReference();
            Attr uriAttr = cr.getURIAsAttr();
            XMLSignatureInput input = null;
            try {
                ResourceResolverContext resolverContext = new ResourceResolverContext(uriAttr, null, this.secureValidation);
                if (!resolverContext.isURISafeToResolve()) {
                    String uriToResolve = uriAttr != null ? uriAttr.getValue() : null;
                    Object[] exArgs = new Object[]{uriToResolve != null ? uriToResolve : "null", null};
                    throw new ResourceResolverException("utils.resolver.noClass", exArgs, uriToResolve, null);
                }
                input = ResourceResolver.resolve(resolverContext);
            }
            catch (ResourceResolverException ex) {
                throw new XMLEncryptionException(ex);
            }
            if (input == null) {
                LOG.log(System.Logger.Level.DEBUG, "Failed to resolve URI \"{0}\"", cr.getURI());
                throw new XMLEncryptionException();
            }
            LOG.log(System.Logger.Level.DEBUG, "Managed to resolve URI \"{0}\"", cr.getURI());
            Transforms transforms = cr.getTransforms();
            if (transforms != null) {
                LOG.log(System.Logger.Level.DEBUG, "Have transforms in cipher reference");
                try {
                    sqsaml.org.apache.xml.security.transforms.Transforms dsTransforms = transforms.getDSTransforms();
                    dsTransforms.setSecureValidation(this.secureValidation);
                    input = dsTransforms.performTransforms(input);
                }
                catch (TransformationException ex) {
                    throw new XMLEncryptionException(ex);
                }
            }
            try {
                return input.getBytes();
            }
            catch (IOException | CanonicalizationException ex) {
                throw new XMLEncryptionException(ex);
            }
        }
        if (this.cipherData.getDataType() != 1) {
            throw new XMLEncryptionException("CipherData.getDataType() returned unexpected value");
        }
        base64EncodedEncryptedOctets = this.cipherData.getCipherValue().getValue();
        LOG.log(System.Logger.Level.DEBUG, "Encrypted octets:\n{0}", base64EncodedEncryptedOctets);
        return XMLUtils.decode(base64EncodedEncryptedOctets);
    }
}

