/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.velocity.runtime.parser.node;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import sqsaml.org.apache.velocity.exception.VelocityException;
import sqsaml.org.apache.velocity.runtime.parser.node.AbstractExecutor;
import sqsaml.org.apache.velocity.util.introspection.Introspector;

public class PublicFieldExecutor
extends AbstractExecutor {
    private final Introspector introspector;
    private Field field = null;

    public PublicFieldExecutor(Logger log, Introspector introspector, Class<?> clazz, String property) {
        this.log = log;
        this.introspector = introspector;
        if (StringUtils.isNotEmpty((CharSequence)property)) {
            this.discover(clazz, property);
        }
    }

    @Override
    public boolean isAlive() {
        return this.getField() != null;
    }

    public Field getField() {
        return this.field;
    }

    protected void setField(Field field) {
        this.field = field;
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void discover(Class<?> clazz, String property) {
        try {
            this.setField(this.introspector.getField(clazz, property));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Exception while looking for public field '" + property;
            this.log.error(msg, (Throwable)e);
            throw new VelocityException(msg, e);
        }
    }

    @Override
    public Object execute(Object o) throws IllegalAccessException, InvocationTargetException {
        return this.isAlive() ? this.getField().get(o) : null;
    }
}

