/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sqsaml.javax.xml.crypto.MarshalException;
import sqsaml.javax.xml.crypto.XMLCryptoContext;
import sqsaml.javax.xml.crypto.XMLStructure;
import sqsaml.javax.xml.crypto.dom.DOMStructure;
import sqsaml.javax.xml.crypto.dsig.spec.TransformParameterSpec;
import sqsaml.javax.xml.crypto.dsig.spec.XSLTTransformParameterSpec;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.ApacheTransform;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMUtils;

public final class DOMXSLTTransform
extends ApacheTransform {
    public void init(TransformParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            throw new InvalidAlgorithmParameterException("params are required");
        }
        if (!(params instanceof XSLTTransformParameterSpec)) {
            throw new InvalidAlgorithmParameterException("unrecognized params");
        }
        this.params = params;
    }

    @Override
    public void init(XMLStructure parent, XMLCryptoContext context) throws InvalidAlgorithmParameterException {
        super.init(parent, context);
        this.unmarshalParams(DOMUtils.getFirstChildElement(this.transformElem));
    }

    private void unmarshalParams(Element sheet) {
        this.params = new XSLTTransformParameterSpec((XMLStructure)new DOMStructure((Node)sheet));
    }

    @Override
    public void marshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        super.marshalParams(parent, context);
        XSLTTransformParameterSpec xp = (XSLTTransformParameterSpec)this.getParameterSpec();
        Node xsltElem = ((DOMStructure)xp.getStylesheet()).getNode();
        DOMUtils.appendChild(this.transformElem, xsltElem);
    }
}

