/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.jcp.xml.dsig.internal.dom;

import java.math.BigInteger;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import sqsaml.javax.xml.crypto.MarshalException;
import sqsaml.javax.xml.crypto.dom.DOMCryptoContext;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMStructure;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import sqsaml.org.apache.xml.security.utils.XMLUtils;

public final class DOMCryptoBinary
extends DOMStructure {
    private final BigInteger bigNum;
    private final String value;

    public DOMCryptoBinary(BigInteger bigNum) {
        if (bigNum == null) {
            throw new NullPointerException("bigNum is null");
        }
        this.bigNum = bigNum;
        byte[] bytes = XMLUtils.getBytes(bigNum, bigNum.bitLength());
        this.value = XMLUtils.encodeToString(bytes);
    }

    public DOMCryptoBinary(Node cbNode) throws MarshalException {
        this.value = cbNode.getNodeValue();
        try {
            this.bigNum = new BigInteger(1, XMLUtils.decode(((Text)cbNode).getData()));
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
    }

    public BigInteger getBigNum() {
        return this.bigNum;
    }

    @Override
    public void marshal(Node parent, String prefix, DOMCryptoContext context) throws MarshalException {
        parent.appendChild(DOMUtils.getOwnerDocument(parent).createTextNode(this.value));
    }
}

