/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.jcp.xml.dsig.internal.dom;

import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sqsaml.javax.xml.crypto.Data;
import sqsaml.javax.xml.crypto.MarshalException;
import sqsaml.javax.xml.crypto.NodeSetData;
import sqsaml.javax.xml.crypto.OctetStreamData;
import sqsaml.javax.xml.crypto.XMLCryptoContext;
import sqsaml.javax.xml.crypto.XMLStructure;
import sqsaml.javax.xml.crypto.dom.DOMCryptoContext;
import sqsaml.javax.xml.crypto.dom.DOMStructure;
import sqsaml.javax.xml.crypto.dsig.TransformException;
import sqsaml.javax.xml.crypto.dsig.TransformService;
import sqsaml.javax.xml.crypto.dsig.spec.TransformParameterSpec;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.ApacheData;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.ApacheNodeSetData;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.ApacheOctetStreamData;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import sqsaml.org.apache.jcp.xml.dsig.internal.dom.Utils;
import sqsaml.org.apache.xml.security.Init;
import sqsaml.org.apache.xml.security.signature.XMLSignatureInput;
import sqsaml.org.apache.xml.security.signature.XMLSignatureNodeInput;
import sqsaml.org.apache.xml.security.signature.XMLSignatureNodeSetInput;
import sqsaml.org.apache.xml.security.signature.XMLSignatureStreamInput;
import sqsaml.org.apache.xml.security.transforms.Transform;

public abstract class ApacheTransform
extends TransformService {
    private static final System.Logger LOG;
    private Transform transform;
    protected Document ownerDoc;
    protected Element transformElem;
    protected TransformParameterSpec params;

    public final AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public void init(XMLStructure parent, XMLCryptoContext context) throws InvalidAlgorithmParameterException {
        if (context != null && !(context instanceof DOMCryptoContext)) {
            throw new ClassCastException("context must be of type DOMCryptoContext");
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        if (!(parent instanceof DOMStructure)) {
            throw new ClassCastException("parent must be of type DOMStructure");
        }
        this.transformElem = (Element)((DOMStructure)parent).getNode();
        this.ownerDoc = DOMUtils.getOwnerDocument(this.transformElem);
    }

    public void marshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        if (context != null && !(context instanceof DOMCryptoContext)) {
            throw new ClassCastException("context must be of type DOMCryptoContext");
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        if (!(parent instanceof DOMStructure)) {
            throw new ClassCastException("parent must be of type DOMStructure");
        }
        this.transformElem = (Element)((DOMStructure)parent).getNode();
        this.ownerDoc = DOMUtils.getOwnerDocument(this.transformElem);
    }

    public Data transform(Data data, XMLCryptoContext xc) throws TransformException {
        if (data == null) {
            throw new NullPointerException("data must not be null");
        }
        return this.transformIt(data, xc, null);
    }

    public Data transform(Data data, XMLCryptoContext xc, OutputStream os) throws TransformException {
        if (data == null) {
            throw new NullPointerException("data must not be null");
        }
        if (os == null) {
            throw new NullPointerException("output stream must not be null");
        }
        return this.transformIt(data, xc, os);
    }

    private Data transformIt(Data data, XMLCryptoContext xc, OutputStream os) throws TransformException {
        XMLSignatureInput in;
        String algorithm;
        if (this.ownerDoc == null) {
            throw new TransformException("transform must be marshalled");
        }
        if (this.transform == null) {
            try {
                this.transform = new Transform(this.ownerDoc, this.getAlgorithm(), this.transformElem.getChildNodes());
                this.transform.setElement(this.transformElem, xc.getBaseURI());
                LOG.log(System.Logger.Level.DEBUG, "Created transform for algorithm: {0}", this.getAlgorithm());
            }
            catch (Exception ex) {
                throw new TransformException("Couldn't find Transform for: " + this.getAlgorithm(), (Throwable)ex);
            }
        }
        if (Utils.secureValidation(xc) && "http://www.w3.org/TR/1999/REC-xslt-19991116".equals(algorithm = this.getAlgorithm())) {
            throw new TransformException("Transform " + algorithm + " is forbidden when secure validation is enabled");
        }
        if (data instanceof ApacheData) {
            LOG.log(System.Logger.Level.DEBUG, "ApacheData = true");
            in = ((ApacheData)data).getXMLSignatureInput();
        } else if (data instanceof NodeSetData) {
            LOG.log(System.Logger.Level.DEBUG, "isNodeSet() = true");
            if (data instanceof DOMSubTreeData) {
                LOG.log(System.Logger.Level.DEBUG, "DOMSubTreeData = true");
                DOMSubTreeData subTree = (DOMSubTreeData)data;
                in = new XMLSignatureNodeInput(subTree.getRoot());
                in.setExcludeComments(subTree.excludeComments());
            } else {
                Set<Node> nodeSet = Utils.toNodeSet(((NodeSetData)data).iterator());
                in = new XMLSignatureNodeSetInput(nodeSet);
            }
        } else {
            LOG.log(System.Logger.Level.DEBUG, "isNodeSet() = false");
            try {
                in = new XMLSignatureStreamInput(((OctetStreamData)data).getOctetStream());
            }
            catch (Exception ex) {
                throw new TransformException((Throwable)ex);
            }
        }
        boolean secVal = Utils.secureValidation(xc);
        in.setSecureValidation(secVal);
        try {
            if (os != null) {
                if (!(in = this.transform.performTransform(in, os, secVal)).isNodeSet() && !in.isElement()) {
                    return null;
                }
            } else {
                in = this.transform.performTransform(in, secVal);
            }
            if (in.hasUnprocessedInput()) {
                return new ApacheOctetStreamData(in);
            }
            return new ApacheNodeSetData(in);
        }
        catch (Exception ex) {
            throw new TransformException((Throwable)ex);
        }
    }

    public final boolean isFeatureSupported(String feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        return false;
    }

    static {
        Init.init();
        LOG = System.getLogger(ApacheTransform.class.getName());
    }
}

