/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sqsaml.org.apache.commons.ssl.Certificates;
import sqsaml.org.apache.commons.ssl.JavaImpl;
import sqsaml.org.apache.commons.ssl.KeyStoreBuilder;
import sqsaml.org.apache.commons.ssl.TrustChain;
import sqsaml.org.apache.commons.ssl.Util;

public class TrustMaterial
extends TrustChain {
    private static final Log logger = LogFactory.getLog(TrustMaterial.class);
    static final int SIMPLE_TRUST_TYPE_TRUST_ALL = 1;
    static final int SIMPLE_TRUST_TYPE_TRUST_THIS_JVM = 2;
    public static final TrustMaterial CACERTS;
    public static final TrustMaterial JSSE_CACERTS;
    public static final TrustMaterial DEFAULT;
    public static final String TRUST_STORE_PASSWORD_PROPERTY = "sqsaml.org.apache.commons.ssl.trustStorePassword";
    public static final TrustMaterial TRUST_ALL;
    public static final TrustMaterial TRUST_THIS_JVM;
    public final int simpleTrustType;
    private final KeyStore jks;

    static TrustMaterial loadCerts(String pathToCerts, char[] trustStorePassword) {
        TrustMaterial cacerts = null;
        try {
            File f = new File(pathToCerts);
            if (f.exists()) {
                cacerts = new TrustMaterial(pathToCerts, trustStorePassword);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        return cacerts;
    }

    static char[] getTrustStorePassword() {
        String trustStorePassword = System.getProperty(TRUST_STORE_PASSWORD_PROPERTY);
        if (trustStorePassword != null) {
            return trustStorePassword.toCharArray();
        }
        return null;
    }

    private TrustMaterial(int simpleTrustType) {
        this(null, simpleTrustType);
    }

    TrustMaterial(KeyStore jks, int simpleTrustType) {
        this.jks = jks == null && simpleTrustType != 0 ? (CACERTS != null ? TrustMaterial.CACERTS.jks : TrustMaterial.JSSE_CACERTS.jks) : jks;
        this.addTrustMaterial(this);
        this.simpleTrustType = simpleTrustType;
    }

    public TrustMaterial(Collection x509Certs) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        TrustMaterial.loadCerts(ks, x509Certs);
        this.jks = ks;
        this.addTrustMaterial(this);
        this.simpleTrustType = 0;
    }

    public TrustMaterial(X509Certificate x509Cert) throws GeneralSecurityException, IOException {
        this(Collections.singleton(x509Cert));
    }

    public TrustMaterial(X509Certificate[] x509Certs) throws GeneralSecurityException, IOException {
        this(Arrays.asList(x509Certs));
    }

    public TrustMaterial(byte[] pemBase64) throws GeneralSecurityException, IOException {
        this(pemBase64, null);
    }

    public TrustMaterial(InputStream pemBase64) throws GeneralSecurityException, IOException {
        this(Util.streamToBytes(pemBase64));
    }

    public TrustMaterial(String pathToPemFile) throws GeneralSecurityException, IOException {
        this(new FileInputStream(pathToPemFile));
    }

    public TrustMaterial(File pemFile) throws GeneralSecurityException, IOException {
        this(new FileInputStream(pemFile));
    }

    public TrustMaterial(URL urlToPemFile) throws GeneralSecurityException, IOException {
        this(urlToPemFile.openStream());
    }

    public TrustMaterial(String pathToJksFile, char[] password) throws GeneralSecurityException, IOException {
        this(new File(pathToJksFile), password);
    }

    public TrustMaterial(File jksFile, char[] password) throws GeneralSecurityException, IOException {
        this(new FileInputStream(jksFile), password);
    }

    public TrustMaterial(URL urlToJKS, char[] password) throws GeneralSecurityException, IOException {
        this(urlToJKS.openStream(), password);
    }

    public TrustMaterial(InputStream jks, char[] password) throws GeneralSecurityException, IOException {
        this(Util.streamToBytes(jks), password);
    }

    public TrustMaterial(byte[] jks, char[] password) throws GeneralSecurityException, IOException {
        KeyStore ks;
        KeyStoreBuilder.BuildResult br = KeyStoreBuilder.parse(jks, password, null, true);
        if (br.jks != null) {
            this.jks = br.jks;
        } else {
            Certificate[] c;
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            if (br.chains != null && !br.chains.isEmpty() && (c = (Certificate[])br.chains.get(0)).length > 0) {
                ks.load(null, password);
                TrustMaterial.loadCerts(ks, Arrays.asList(c));
            }
            this.jks = ks;
        }
        ks = this.jks;
        boolean hasCertificates = false;
        Enumeration<String> en = ks.aliases();
        while (en.hasMoreElements()) {
            String alias = en.nextElement();
            if (!ks.isCertificateEntry(alias)) continue;
            hasCertificates = true;
            break;
        }
        if (!hasCertificates) {
            throw new KeyStoreException("TrustMaterial couldn't load any certificates to trust!");
        }
        this.addTrustMaterial(this);
        this.simpleTrustType = 0;
    }

    public KeyStore getKeyStore() {
        return this.jks;
    }

    private static void loadCerts(KeyStore ks, Collection certs) throws KeyStoreException {
        Iterator it = certs.iterator();
        int count = 0;
        while (it.hasNext()) {
            X509Certificate cert = (X509Certificate)it.next();
            String cn = Certificates.getCN(cert);
            String alias = cn + "_" + count;
            ks.setCertificateEntry(alias, cert);
            ++count;
        }
    }

    @Override
    protected boolean containsTrustAll() {
        boolean yes;
        boolean bl = yes = this.simpleTrustType == 1;
        if (!yes) {
            yes = super.containsTrustAll();
        }
        return yes;
    }

    static {
        JavaImpl.load();
        String javaHome = System.getProperty("java.home");
        String pathToCacerts = javaHome + "/lib/security/cacerts";
        String pathToJSSECacerts = javaHome + "/lib/security/jssecacerts";
        char[] trustStorePassword = TrustMaterial.getTrustStorePassword();
        CACERTS = TrustMaterial.loadCerts(pathToCacerts, trustStorePassword);
        JSSE_CACERTS = TrustMaterial.loadCerts(pathToJSSECacerts, trustStorePassword);
        DEFAULT = JSSE_CACERTS != null ? JSSE_CACERTS : CACERTS;
        TRUST_ALL = new TrustMaterial(1);
        TRUST_THIS_JVM = new TrustMaterial(2);
    }
}

