/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import sqsaml.org.apache.commons.ssl.SSL;
import sqsaml.org.apache.commons.ssl.SSLWrapperFactory;

public class SSLServerSocketWrapper
extends SSLServerSocket {
    protected SSLServerSocket s;
    protected SSL ssl;
    protected SSLWrapperFactory wf;

    public SSLServerSocketWrapper(SSLServerSocket s, SSL ssl, SSLWrapperFactory wf) throws IOException {
        this.s = s;
        this.ssl = ssl;
        this.wf = wf;
    }

    @Override
    public Socket accept() throws IOException {
        SSLSocket secureSocket = (SSLSocket)this.s.accept();
        this.ssl.doPreConnectSocketStuff(secureSocket);
        InetAddress addr = secureSocket.getInetAddress();
        String hostName = addr.getHostName();
        this.ssl.doPostConnectSocketStuff(secureSocket, hostName);
        return this.wf.wrap(secureSocket);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.s.getEnabledCipherSuites();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.s.getEnabledProtocols();
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.s.getEnableSessionCreation();
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.s.getNeedClientAuth();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.s.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.s.getSupportedProtocols();
    }

    @Override
    public boolean getUseClientMode() {
        return this.s.getUseClientMode();
    }

    @Override
    public boolean getWantClientAuth() {
        return this.s.getWantClientAuth();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.s.setEnabledCipherSuites(suites);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.s.setEnabledProtocols(protocols);
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.s.setEnableSessionCreation(flag);
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.s.setNeedClientAuth(need);
    }

    @Override
    public void setUseClientMode(boolean use) {
        this.s.setUseClientMode(use);
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.s.setWantClientAuth(want);
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        this.s.bind(endpoint);
    }

    @Override
    public void bind(SocketAddress ep, int bl) throws IOException {
        this.s.bind(ep, bl);
    }

    @Override
    public void close() throws IOException {
        this.s.close();
    }

    @Override
    public ServerSocketChannel getChannel() {
        return this.s.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.s.getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.s.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.s.getLocalSocketAddress();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.s.getReceiveBufferSize();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.s.getReuseAddress();
    }

    @Override
    public int getSoTimeout() throws IOException {
        return this.s.getSoTimeout();
    }

    @Override
    public boolean isBound() {
        return this.s.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.s.isClosed();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.s.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.s.setReuseAddress(on);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.s.setSoTimeout(timeout);
    }

    @Override
    public String toString() {
        return this.s.toString();
    }
}

