/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.ssl;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import sqsaml.org.apache.commons.ssl.HostnameVerifier;
import sqsaml.org.apache.commons.ssl.KeyMaterial;
import sqsaml.org.apache.commons.ssl.SSL;
import sqsaml.org.apache.commons.ssl.SSLWrapperFactory;
import sqsaml.org.apache.commons.ssl.TomcatServerXML;
import sqsaml.org.apache.commons.ssl.TrustChain;
import sqsaml.org.apache.commons.ssl.TrustMaterial;

public class SSLServer
extends SSLServerSocketFactory {
    protected final SSL ssl = new SSL();

    public SSLServer() throws GeneralSecurityException, IOException {
        this.setCheckHostname(false);
        if (!this.ssl.usingSystemProperties) {
            this.useDefaultKeyMaterial();
        }
    }

    public boolean useTomcatSSLMaterial() throws GeneralSecurityException, IOException {
        Integer p8443 = 8443;
        KeyMaterial km = (KeyMaterial)TomcatServerXML.KEY_MATERIAL_BY_PORT.get(p8443);
        TrustMaterial tm = (TrustMaterial)TomcatServerXML.TRUST_MATERIAL_BY_PORT.get(p8443);
        km = km == null ? TomcatServerXML.KEY_MATERIAL : km;
        tm = tm == null ? TomcatServerXML.TRUST_MATERIAL : tm;
        boolean success = false;
        if (km != null) {
            this.setKeyMaterial(km);
            success = true;
            if (tm != null && !TrustMaterial.DEFAULT.equals(tm)) {
                this.setTrustMaterial(tm);
            }
        }
        return success;
    }

    private boolean useDefaultKeyMaterial() throws GeneralSecurityException, IOException {
        Properties props = System.getProperties();
        boolean pwdSet = props.containsKey("javax.net.ssl.keyStorePassword");
        String pwd = props.getProperty("javax.net.ssl.keyStorePassword");
        pwd = pwdSet ? pwd : "changeit";
        String userHome = System.getProperty("user.home");
        String path = userHome + "/.keystore";
        File f = new File(path);
        boolean success = false;
        if (f.exists()) {
            KeyMaterial km;
            block4: {
                km = null;
                try {
                    km = new KeyMaterial(path, pwd.toCharArray());
                }
                catch (Exception e) {
                    if (!pwdSet) break block4;
                    System.err.println("commons-ssl automatic loading of [" + path + "] failed. ");
                    System.err.println(e);
                }
            }
            if (km != null) {
                this.setKeyMaterial(km);
                success = true;
            }
        }
        return success;
    }

    public void setDnsOverride(Map m) {
        this.ssl.setDnsOverride(m);
    }

    public void addTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.addTrustMaterial(trustChain);
    }

    public void setTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.setTrustMaterial(trustChain);
    }

    public void setKeyMaterial(KeyMaterial keyMaterial) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.ssl.setKeyMaterial(keyMaterial);
    }

    public void setCheckCRL(boolean b) {
        this.ssl.setCheckCRL(b);
    }

    public void setCheckExpiry(boolean b) {
        this.ssl.setCheckExpiry(b);
    }

    public void setCheckHostname(boolean b) {
        this.ssl.setCheckHostname(b);
    }

    public void setConnectTimeout(int i) {
        this.ssl.setConnectTimeout(i);
    }

    public void setDefaultProtocol(String s) {
        this.ssl.setDefaultProtocol(s);
    }

    public void setEnabledCiphers(String[] ciphers) {
        this.ssl.setEnabledCiphers(ciphers);
    }

    public void setEnabledProtocols(String[] protocols) {
        this.ssl.setEnabledProtocols(protocols);
    }

    public void setHostnameVerifier(HostnameVerifier verifier) {
        this.ssl.setHostnameVerifier(verifier);
    }

    public void setSoTimeout(int soTimeout) {
        this.ssl.setSoTimeout(soTimeout);
    }

    public void setSSLWrapperFactory(SSLWrapperFactory wf) {
        this.ssl.setSSLWrapperFactory(wf);
    }

    public void setNeedClientAuth(boolean b) {
        this.ssl.setNeedClientAuth(b);
    }

    public void setWantClientAuth(boolean b) {
        this.ssl.setWantClientAuth(b);
    }

    public void setUseClientMode(boolean b) {
        this.ssl.setUseClientMode(b);
    }

    public X509Certificate[] getAssociatedCertificateChain() {
        return this.ssl.getAssociatedCertificateChain();
    }

    public boolean getCheckCRL() {
        return this.ssl.getCheckCRL();
    }

    public boolean getCheckExpiry() {
        return this.ssl.getCheckExpiry();
    }

    public boolean getCheckHostname() {
        return this.ssl.getCheckHostname();
    }

    public int getConnectTimeout() {
        return this.ssl.getConnectTimeout();
    }

    public String getDefaultProtocol() {
        return this.ssl.getDefaultProtocol();
    }

    public String[] getEnabledCiphers() {
        return this.ssl.getEnabledCiphers();
    }

    public String[] getEnabledProtocols() {
        return this.ssl.getEnabledProtocols();
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.ssl.getHostnameVerifier();
    }

    public int getSoTimeout() {
        return this.ssl.getSoTimeout();
    }

    public SSLWrapperFactory getSSLWrapperFactory() {
        return this.ssl.getSSLWrapperFactory();
    }

    public boolean getNeedClientAuth() {
        return this.ssl.getNeedClientAuth();
    }

    public boolean getWantClientAuth() {
        return this.ssl.getWantClientAuth();
    }

    public boolean getUseClientMode() {
        return !this.ssl.getUseClientModeDefault() && this.ssl.getUseClientMode();
    }

    public SSLContext getSSLContext() throws GeneralSecurityException, IOException {
        return this.ssl.getSSLContext();
    }

    public TrustChain getTrustChain() {
        return this.ssl.getTrustChain();
    }

    public X509Certificate[] getCurrentClientChain() {
        return this.ssl.getCurrentClientChain();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.ssl.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.ssl.getSupportedCipherSuites();
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return this.ssl.createServerSocket();
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.createServerSocket(port, 50);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.createServerSocket(port, backlog, null);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress localHost) throws IOException {
        return this.ssl.createServerSocket(port, backlog, localHost);
    }
}

