/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.ssl;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sqsaml.org.apache.commons.ssl.HostnameVerifier;
import sqsaml.org.apache.commons.ssl.JavaImpl;
import sqsaml.org.apache.commons.ssl.KeyMaterial;
import sqsaml.org.apache.commons.ssl.SSLWrapperFactory;
import sqsaml.org.apache.commons.ssl.TrustChain;
import sqsaml.org.apache.commons.ssl.TrustMaterial;

public class SSL {
    private static final String[] KNOWN_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3", "SSLv2", "SSLv2Hello"};
    private static final String[] SUPPORTED_CIPHERS;
    public static final SortedSet KNOWN_PROTOCOLS_SET;
    public static final SortedSet SUPPORTED_CIPHERS_SET;
    private Object sslContext = null;
    private int initCount = 0;
    private SSLSocketFactory socketFactory = null;
    private SSLServerSocketFactory serverSocketFactory = null;
    private HostnameVerifier hostnameVerifier = HostnameVerifier.DEFAULT;
    private boolean isSecure = true;
    private boolean checkHostname = true;
    private boolean checkCRL = true;
    private boolean checkExpiry = true;
    private boolean useClientMode = false;
    private boolean useClientModeDefault = true;
    private int soTimeout = 86400000;
    private int connectTimeout = 3600000;
    private TrustChain trustChain = null;
    private KeyMaterial keyMaterial = null;
    private String[] enabledCiphers = null;
    private String[] enabledProtocols = null;
    private String defaultProtocol = "TLS";
    private X509Certificate[] currentServerChain;
    private X509Certificate[] currentClientChain;
    private boolean wantClientAuth = true;
    private boolean needClientAuth = false;
    private SSLWrapperFactory sslWrapperFactory = SSLWrapperFactory.NO_WRAP;
    private Map dnsOverride;
    protected final boolean usingSystemProperties;

    public SSL() throws GeneralSecurityException, IOException {
        boolean usingSysProps = false;
        Properties props = System.getProperties();
        boolean ksSet = props.containsKey("javax.net.ssl.keyStore");
        boolean tsSet = props.containsKey("javax.net.ssl.trustStore");
        if (ksSet) {
            String path = System.getProperty("javax.net.ssl.keyStore");
            String pwd = System.getProperty("javax.net.ssl.keyStorePassword");
            pwd = pwd != null ? pwd : "";
            File f = new File(path);
            if (f.exists()) {
                KeyMaterial km = new KeyMaterial(path, pwd.toCharArray());
                this.setKeyMaterial(km);
                usingSysProps = true;
            }
        }
        boolean trustMaterialSet = false;
        if (tsSet) {
            String path = System.getProperty("javax.net.ssl.trustStore");
            String pwd = System.getProperty("javax.net.ssl.trustStorePassword");
            boolean pwdWasNull = pwd == null;
            pwd = pwdWasNull ? "" : pwd;
            File f = new File(path);
            if (f.exists()) {
                TrustMaterial tm;
                try {
                    tm = new TrustMaterial(path, pwd.toCharArray());
                }
                catch (GeneralSecurityException gse) {
                    if (pwdWasNull) {
                        tm = new TrustMaterial(path);
                    }
                    throw gse;
                }
                this.setTrustMaterial(tm);
                usingSysProps = true;
                trustMaterialSet = true;
            }
        }
        if (!trustMaterialSet) {
            this.setTrustMaterial(TrustMaterial.DEFAULT);
        }
        this.usingSystemProperties = usingSysProps;
        this.dirtyAndReloadIfYoung();
    }

    private void dirty() {
        this.sslContext = null;
        this.socketFactory = null;
        this.serverSocketFactory = null;
    }

    private void dirtyAndReloadIfYoung() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.dirty();
        if (this.initCount >= 0 && this.initCount <= 5) {
            this.init();
        }
    }

    String dnsOverride(String host) {
        String override;
        if (this.dnsOverride != null && this.dnsOverride.containsKey(host) && (override = (String)this.dnsOverride.get(host)) != null && !"".equals(override.trim())) {
            return override;
        }
        return host;
    }

    public void setDnsOverride(Map m) {
        this.dnsOverride = m;
    }

    public void setIsSecure(boolean b) {
        this.isSecure = b;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public SSLContext getSSLContext() throws GeneralSecurityException, IOException {
        Object obj = this.getSSLContextAsObject();
        if (JavaImpl.isJava13()) {
            try {
                return (SSLContext)obj;
            }
            catch (ClassCastException cce) {
                throw new ClassCastException("When using Java13 SSL, you must call SSL.getSSLContextAsObject() - " + cce);
            }
        }
        return (SSLContext)obj;
    }

    public Object getSSLContextAsObject() throws GeneralSecurityException, IOException {
        if (this.sslContext == null) {
            this.init();
        }
        return this.sslContext;
    }

    public void addTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        if (this.trustChain == null || trustChain == TrustMaterial.TRUST_ALL) {
            this.trustChain = trustChain;
        } else {
            this.trustChain.addTrustMaterial(trustChain);
        }
        this.dirtyAndReloadIfYoung();
    }

    public void setTrustMaterial(TrustChain trustChain) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.trustChain = trustChain;
        this.dirtyAndReloadIfYoung();
    }

    public void setKeyMaterial(KeyMaterial keyMaterial) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.keyMaterial = keyMaterial;
        this.dirtyAndReloadIfYoung();
    }

    public X509Certificate[] getAssociatedCertificateChain() {
        if (this.keyMaterial != null) {
            List list = this.keyMaterial.getAssociatedCertificateChains();
            return (X509Certificate[])list.get(0);
        }
        return null;
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers != null ? this.enabledCiphers : this.getDefaultCipherSuites();
    }

    public void setEnabledCiphers(String[] ciphers) {
        HashSet<String> desired = new HashSet<String>(Arrays.asList(ciphers));
        desired.removeAll(SUPPORTED_CIPHERS_SET);
        if (!desired.isEmpty()) {
            throw new IllegalArgumentException("following ciphers not supported: " + desired);
        }
        this.enabledCiphers = ciphers;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = protocols;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(String protocol) {
        this.defaultProtocol = protocol;
        this.dirty();
    }

    public boolean getCheckHostname() {
        return this.checkHostname;
    }

    public void setCheckHostname(boolean checkHostname) {
        this.checkHostname = checkHostname;
    }

    public void setHostnameVerifier(HostnameVerifier verifier) {
        if (verifier == null) {
            verifier = HostnameVerifier.DEFAULT;
        }
        this.hostnameVerifier = verifier;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public boolean getCheckCRL() {
        return this.checkCRL;
    }

    public void setCheckCRL(boolean checkCRL) {
        this.checkCRL = checkCRL;
    }

    public boolean getCheckExpiry() {
        return this.checkExpiry;
    }

    public void setCheckExpiry(boolean checkExpiry) {
        this.checkExpiry = checkExpiry;
    }

    public void setSoTimeout(int soTimeout) {
        if (soTimeout < 0) {
            throw new IllegalArgumentException("soTimeout must not be negative");
        }
        this.soTimeout = soTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must not be negative");
        }
        this.connectTimeout = connectTimeout;
    }

    public void setUseClientMode(boolean useClientMode) {
        this.useClientModeDefault = false;
        this.useClientMode = useClientMode;
    }

    public boolean getUseClientModeDefault() {
        return this.useClientModeDefault;
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public SSLWrapperFactory getSSLWrapperFactory() {
        return this.sslWrapperFactory;
    }

    public void setSSLWrapperFactory(SSLWrapperFactory wf) {
        this.sslWrapperFactory = wf;
    }

    private void initThrowRuntime() {
        try {
            this.init();
        }
        catch (GeneralSecurityException gse) {
            throw JavaImpl.newRuntimeException(gse);
        }
        catch (IOException ioe) {
            throw JavaImpl.newRuntimeException(ioe);
        }
    }

    private void init() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateException {
        this.socketFactory = null;
        this.serverSocketFactory = null;
        this.sslContext = JavaImpl.init(this, this.trustChain, this.keyMaterial);
        ++this.initCount;
    }

    public void doPreConnectSocketStuff(Socket s) throws IOException {
        if (s instanceof SSLSocket && !this.useClientModeDefault) {
            ((SSLSocket)s).setUseClientMode(this.useClientMode);
        }
        if (this.soTimeout > 0) {
            s.setSoTimeout(this.soTimeout);
        }
        if (s instanceof SSLSocket) {
            if (this.enabledProtocols != null) {
                JavaImpl.setEnabledProtocols(s, this.enabledProtocols);
            }
            if (this.enabledCiphers != null) {
                ((SSLSocket)s).setEnabledCipherSuites(this.enabledCiphers);
            }
        }
    }

    public void doPostConnectSocketStuff(Socket s, String host) throws IOException {
        if (this.checkHostname && s instanceof SSLSocket) {
            this.hostnameVerifier.check(host, (SSLSocket)s);
        }
    }

    public Socket createSocket() throws IOException {
        if (this.isSecure) {
            return this.sslWrapperFactory.wrap(JavaImpl.createSocket(this));
        }
        Socket s = SocketFactory.getDefault().createSocket();
        this.doPreConnectSocketStuff(s);
        return s;
    }

    public Socket createSocket(String remoteHost, int remotePort, InetAddress localHost, int localPort, int timeout) throws IOException {
        int factoryTimeout = this.getConnectTimeout();
        int connectTimeout = timeout == 0 ? factoryTimeout : timeout;
        Socket s = this.isSecure ? JavaImpl.createSocket(this, remoteHost, remotePort, localHost, localPort, connectTimeout) : JavaImpl.createPlainSocket(this, remoteHost, remotePort, localHost, localPort, connectTimeout);
        return this.sslWrapperFactory.wrap(s);
    }

    public Socket createSocket(Socket s, String remoteHost, int remotePort, boolean autoClose) throws IOException {
        SSLSocketFactory sf = this.getSSLSocketFactory();
        s = sf.createSocket(s, remoteHost, remotePort, autoClose);
        this.doPreConnectSocketStuff(s);
        this.doPostConnectSocketStuff(s, remoteHost);
        return this.sslWrapperFactory.wrap(s);
    }

    public ServerSocket createServerSocket() throws IOException {
        SSLServerSocket ss = JavaImpl.createServerSocket(this);
        return this.getSSLWrapperFactory().wrap(ss, this);
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress localHost) throws IOException {
        SSLServerSocketFactory f = this.getSSLServerSocketFactory();
        ServerSocket ss = f.createServerSocket(port, backlog, localHost);
        SSLServerSocket s = (SSLServerSocket)ss;
        this.doPreConnectServerSocketStuff(s);
        return this.getSSLWrapperFactory().wrap(s, this);
    }

    public void doPreConnectServerSocketStuff(SSLServerSocket s) throws IOException {
        if (this.soTimeout > 0) {
            s.setSoTimeout(this.soTimeout);
        }
        if (this.enabledProtocols != null) {
            JavaImpl.setEnabledProtocols(s, this.enabledProtocols);
        }
        if (this.enabledCiphers != null) {
            s.setEnabledCipherSuites(this.enabledCiphers);
        }
        if (!this.wantClientAuth) {
            JavaImpl.setWantClientAuth(s, false);
        }
        if (!this.needClientAuth) {
            s.setNeedClientAuth(false);
        }
        if (this.wantClientAuth) {
            JavaImpl.setWantClientAuth(s, true);
        }
        if (this.needClientAuth) {
            s.setNeedClientAuth(true);
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.sslContext == null) {
            this.initThrowRuntime();
        }
        if (this.socketFactory == null) {
            this.socketFactory = JavaImpl.getSSLSocketFactory(this.sslContext);
        }
        return this.socketFactory;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory() {
        if (this.sslContext == null) {
            this.initThrowRuntime();
        }
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = JavaImpl.getSSLServerSocketFactory(this.sslContext);
        }
        return this.serverSocketFactory;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public String[] getDefaultCipherSuites() {
        return this.getSSLSocketFactory().getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        String[] s = new String[SUPPORTED_CIPHERS.length];
        System.arraycopy(SUPPORTED_CIPHERS, 0, s, 0, s.length);
        return s;
    }

    public TrustChain getTrustChain() {
        return this.trustChain;
    }

    public void setCurrentServerChain(X509Certificate[] chain) {
        this.currentServerChain = chain;
    }

    public void setCurrentClientChain(X509Certificate[] chain) {
        this.currentClientChain = chain;
    }

    public X509Certificate[] getCurrentServerChain() {
        return this.currentServerChain;
    }

    public X509Certificate[] getCurrentClientChain() {
        return this.currentClientChain;
    }

    static {
        TreeSet<Object> ts = new TreeSet(Collections.reverseOrder());
        ts.addAll(Arrays.asList(KNOWN_PROTOCOLS));
        KNOWN_PROTOCOLS_SET = Collections.unmodifiableSortedSet(ts);
        SSLSocketFactory s = (SSLSocketFactory)SSLSocketFactory.getDefault();
        ts = new TreeSet();
        SUPPORTED_CIPHERS = s.getSupportedCipherSuites();
        Arrays.sort(SUPPORTED_CIPHERS);
        ts.addAll(Arrays.asList(SUPPORTED_CIPHERS));
        SUPPORTED_CIPHERS_SET = Collections.unmodifiableSortedSet(ts);
    }
}

