/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.ssl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sqsaml.org.apache.commons.ssl.Base64;
import sqsaml.org.apache.commons.ssl.CRLSocket;
import sqsaml.org.apache.commons.ssl.JavaImpl;
import sqsaml.org.apache.commons.ssl.TrustMaterial;
import sqsaml.org.apache.commons.ssl.Util;

public class Certificates {
    private static final Log logger = LogFactory.getLog(Certificates.class);
    public static final CertificateFactory CF;
    public static final String LINE_ENDING;
    private static final HashMap crl_cache;
    public static final String CRL_EXTENSION = "2.5.29.31";
    public static final String OCSP_EXTENSION = "1.3.6.1.5.5.7.1.1";
    private static final DateFormat DF;
    public static final SerializableComparator COMPARE_BY_EXPIRY;

    public static String toPEMString(X509Certificate cert) throws CertificateEncodingException {
        return Certificates.toString(cert.getEncoded());
    }

    public static String toString(byte[] x509Encoded) {
        byte[] encoded = Base64.encodeBase64(x509Encoded);
        StringBuffer buf = new StringBuffer(encoded.length + 100);
        buf.append("-----BEGIN CERTIFICATE-----\n");
        for (int i = 0; i < encoded.length; i += 64) {
            if (encoded.length - i >= 64) {
                buf.append(new String(encoded, i, 64));
            } else {
                buf.append(new String(encoded, i, encoded.length - i));
            }
            buf.append(LINE_ENDING);
        }
        buf.append("-----END CERTIFICATE-----");
        buf.append(LINE_ENDING);
        return buf.toString();
    }

    public static String toString(X509Certificate cert) {
        return Certificates.toString(cert, false);
    }

    public static String toString(X509Certificate cert, boolean htmlStyle) {
        String cn = Certificates.getCN(cert);
        String startStart = DF.format(cert.getNotBefore());
        String endDate = DF.format(cert.getNotAfter());
        String subject = JavaImpl.getSubjectX500(cert);
        String issuer = JavaImpl.getIssuerX500(cert);
        Iterator crls = Certificates.getCRLs(cert).iterator();
        if (subject.equals(issuer)) {
            issuer = "self-signed";
        }
        StringBuffer buf = new StringBuffer(128);
        if (htmlStyle) {
            buf.append("<strong class=\"cn\">");
        }
        buf.append(cn);
        if (htmlStyle) {
            buf.append("</strong>");
        }
        buf.append(LINE_ENDING);
        buf.append("Valid: ");
        buf.append(startStart);
        buf.append(" - ");
        buf.append(endDate);
        buf.append(LINE_ENDING);
        buf.append("s: ");
        buf.append(subject);
        buf.append(LINE_ENDING);
        buf.append("i: ");
        buf.append(issuer);
        while (crls.hasNext()) {
            buf.append(LINE_ENDING);
            buf.append("CRL: ");
            buf.append((String)crls.next());
        }
        buf.append(LINE_ENDING);
        return buf.toString();
    }

    public static List getCRLs(X509Extension cert) {
        String s;
        byte[] bytes = cert.getExtensionValue(CRL_EXTENSION);
        LinkedList<String> httpCRLS = new LinkedList<String>();
        LinkedList<String> ftpCRLS = new LinkedList<String>();
        LinkedList<String> otherCRLS = new LinkedList<String>();
        if (bytes == null) {
            return httpCRLS;
        }
        try {
            s = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            s = new String(bytes);
        }
        int pos = 0;
        while (pos >= 0) {
            int x = -1;
            int[] indexes = new int[]{s.indexOf("http", pos), s.indexOf("ldap", pos), s.indexOf("file", pos), s.indexOf("ftp", pos)};
            Arrays.sort(indexes);
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] < 0) continue;
                x = indexes[i];
                break;
            }
            if (x >= 0) {
                String crlTest;
                String crl;
                int y = s.indexOf(65533, x);
                String string = crl = y > x ? s.substring(x, y - 1) : s.substring(x);
                if (y > x && crl.endsWith("0")) {
                    crl = crl.substring(0, crl.length() - 1);
                }
                if ((crlTest = crl.trim().toLowerCase()).startsWith("http")) {
                    httpCRLS.add(crl);
                } else if (crlTest.startsWith("ftp")) {
                    ftpCRLS.add(crl);
                } else {
                    otherCRLS.add(crl);
                }
                pos = y;
                continue;
            }
            pos = -1;
        }
        httpCRLS.addAll(ftpCRLS);
        httpCRLS.addAll(otherCRLS);
        return httpCRLS;
    }

    public static void checkCRL(X509Certificate cert) throws CertificateException {
        byte[] bytes = cert.getExtensionValue(CRL_EXTENSION);
        if (bytes != null) {
            List crlList = Certificates.getCRLs(cert);
            for (String url : crlList) {
                boolean success;
                CRLHolder holder = (CRLHolder)crl_cache.get(url);
                if (holder == null) {
                    holder = new CRLHolder(url);
                    crl_cache.put(url, holder);
                }
                if (!(success = holder.checkCRL(cert))) continue;
                break;
            }
        }
    }

    public static BigInteger getFingerprint(X509Certificate x509) throws CertificateEncodingException {
        return Certificates.getFingerprint(x509.getEncoded());
    }

    public static BigInteger getFingerprint(byte[] x509) throws CertificateEncodingException {
        MessageDigest sha1;
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw JavaImpl.newRuntimeException(nsae);
        }
        sha1.reset();
        byte[] result = sha1.digest(x509);
        return new BigInteger(result);
    }

    public static String getCN(X509Certificate cert) {
        String[] cns = Certificates.getCNs(cert);
        boolean foundSomeCNs = cns != null && cns.length >= 1;
        return foundSomeCNs ? cns[0] : null;
    }

    public static String[] getCNs(X509Certificate cert) {
        try {
            String subjectPrincipal = cert.getSubjectX500Principal().getName("RFC2253");
            LinkedList<String> cnList = new LinkedList<String>();
            LdapName subjectDN = new LdapName(subjectPrincipal);
            for (Rdn rds : subjectDN.getRdns()) {
                Attributes attributes = rds.toAttributes();
                Attribute cn = attributes.get("cn");
                if (cn == null) continue;
                try {
                    Object value = cn.get();
                    if (value == null) continue;
                    cnList.add(value.toString());
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                catch (NamingException namingException) {}
            }
            if (!cnList.isEmpty()) {
                return cnList.toArray(new String[cnList.size()]);
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return null;
    }

    public static String[] getDNSSubjectAlts(X509Certificate cert) {
        LinkedList<String> subjectAltList = new LinkedList<String>();
        Collection<List<?>> c = null;
        try {
            c = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            logger.debug((Object)"could not parse certificate", (Throwable)cpe);
        }
        if (c != null) {
            for (List<?> list : c) {
                int type = (Integer)list.get(0);
                if (type != 2) continue;
                String s = (String)list.get(1);
                subjectAltList.add(s);
            }
        }
        if (!subjectAltList.isEmpty()) {
            String[] subjectAlts = new String[subjectAltList.size()];
            subjectAltList.toArray(subjectAlts);
            return subjectAlts;
        }
        return null;
    }

    public static Certificate[] trimChain(Certificate[] chain) {
        for (int i = 0; i < chain.length; ++i) {
            if (chain[i] != null) continue;
            Certificate[] newChain = new X509Certificate[i];
            System.arraycopy(chain, 0, newChain, 0, i);
            return newChain;
        }
        return chain;
    }

    public static X509Certificate[] x509ifyChain(Certificate[] chain) {
        if (chain instanceof X509Certificate[]) {
            return (X509Certificate[])chain;
        }
        X509Certificate[] x509Chain = new X509Certificate[chain.length];
        System.arraycopy(chain, 0, x509Chain, 0, chain.length);
        return x509Chain;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            FileInputStream in = new FileInputStream(args[i]);
            TrustMaterial tm = new TrustMaterial(in);
            for (X509Certificate x509 : tm.getCertificates()) {
                System.out.println(Certificates.toString(x509));
            }
        }
    }

    static {
        LINE_ENDING = System.getProperty("line.separator");
        crl_cache = new HashMap();
        DF = new SimpleDateFormat("yyyy/MMM/dd");
        COMPARE_BY_EXPIRY = new SerializableComparator(){

            public int compare(Object o1, Object o2) {
                BigInteger big2;
                BigInteger big1;
                String s2;
                String s1;
                Date d2;
                X509Certificate c1 = (X509Certificate)o1;
                X509Certificate c2 = (X509Certificate)o2;
                if (c1 == c2) {
                    return 0;
                }
                if (c1 == null) {
                    return -1;
                }
                if (c2 == null) {
                    return 1;
                }
                if (c1.equals(c2)) {
                    return 0;
                }
                Date d1 = c1.getNotAfter();
                int c = d1.compareTo(d2 = c2.getNotAfter());
                if (c == 0 && (c = (s1 = JavaImpl.getSubjectX500(c1)).compareTo(s2 = JavaImpl.getSubjectX500(c2))) == 0 && (c = (s1 = JavaImpl.getIssuerX500(c1)).compareTo(s2 = JavaImpl.getIssuerX500(c2))) == 0 && (c = (big1 = c1.getSerialNumber()).compareTo(big2 = c2.getSerialNumber())) == 0) {
                    try {
                        byte[] b1 = c1.getEncoded();
                        byte[] b2 = c2.getEncoded();
                        int len1 = b1.length;
                        int len2 = b2.length;
                        for (int i = 0; i < len1 && i < len2 && (c = b1[i] - b2[i]) == 0; ++i) {
                        }
                        if (c == 0) {
                            c = b1.length - b2.length;
                        }
                    }
                    catch (CertificateEncodingException cee) {
                        c = 0;
                    }
                }
                return c;
            }
        };
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException ce) {
            logger.error((Object)"certificate exception", (Throwable)ce);
        }
        finally {
            CF = cf;
        }
    }

    private static class CRLHolder {
        private final String urlString;
        private File tempCRLFile;
        private long creationTime;
        private Set passedTest = new HashSet();
        private Set failedTest = new HashSet();

        CRLHolder(String urlString) {
            if (urlString == null) {
                throw new NullPointerException("urlString can't be null");
            }
            this.urlString = urlString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean checkCRL(X509Certificate cert) throws CertificateException {
            BigInteger fingerprint;
            CRL crl = null;
            long now = System.currentTimeMillis();
            if (now - this.creationTime > 86400000L) {
                if (this.tempCRLFile != null && this.tempCRLFile.exists()) {
                    this.tempCRLFile.delete();
                }
                this.tempCRLFile = null;
                this.passedTest.clear();
            }
            if (this.failedTest.contains(fingerprint = Certificates.getFingerprint(cert))) {
                throw new CertificateException("Revoked by CRL (cached response)");
            }
            if (this.passedTest.contains(fingerprint)) {
                return true;
            }
            if (this.tempCRLFile == null) {
                try {
                    URL url = new URL(this.urlString);
                    URLConnection urlConn = url.openConnection();
                    if (urlConn instanceof HttpsURLConnection) {
                        HttpsURLConnection httpsConn = (HttpsURLConnection)urlConn;
                        httpsConn.setSSLSocketFactory(CRLSocket.getSecureInstance());
                    } else if (urlConn instanceof HttpURLConnection) {
                        HttpURLConnection httpConn = (HttpURLConnection)urlConn;
                        try {
                            Class<?> c = httpConn.getClass();
                            Method setConnTimeOut = c.getDeclaredMethod("setConnectTimeout", Integer.TYPE);
                            Method setReadTimeout = c.getDeclaredMethod("setReadTimeout", Integer.TYPE);
                            setConnTimeOut.invoke((Object)httpConn, 5000);
                            setReadTimeout.invoke((Object)httpConn, 5000);
                        }
                        catch (NoSuchMethodException c) {
                        }
                        catch (Exception e) {
                            throw new RuntimeException("can't set timeout", e);
                        }
                    }
                    File tempFile = File.createTempFile("crl", ".tmp");
                    tempFile.deleteOnExit();
                    OutputStream out = new FileOutputStream(tempFile);
                    out = new BufferedOutputStream(out);
                    BufferedInputStream in = new BufferedInputStream(urlConn.getInputStream());
                    try {
                        Util.pipeStream(in, out);
                    }
                    catch (IOException ioe) {
                        tempFile.delete();
                        throw ioe;
                    }
                    this.tempCRLFile = tempFile;
                    this.creationTime = System.currentTimeMillis();
                }
                catch (IOException url) {
                    // empty catch block
                }
            }
            if (this.tempCRLFile != null && this.tempCRLFile.exists()) {
                try {
                    InputStream in = new FileInputStream(this.tempCRLFile);
                    in = new BufferedInputStream(in);
                    CertificateFactory certificateFactory = CF;
                    synchronized (certificateFactory) {
                        crl = CF.generateCRL(in);
                    }
                    in.close();
                    if (crl.isRevoked(cert)) {
                        this.passedTest.remove(fingerprint);
                        this.failedTest.add(fingerprint);
                        throw new CertificateException("Revoked by CRL");
                    }
                    this.passedTest.add(fingerprint);
                }
                catch (IOException iOException) {
                }
                catch (CRLException cRLException) {
                    // empty catch block
                }
            }
            return crl != null;
        }
    }

    public static interface SerializableComparator
    extends Comparator,
    Serializable {
    }
}

