/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.org.apache.commons.configuration;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sqsaml.org.apache.commons.configuration.AbstractConfiguration;
import sqsaml.org.apache.commons.configuration.CombinedConfiguration;
import sqsaml.org.apache.commons.configuration.Configuration;
import sqsaml.org.apache.commons.configuration.HierarchicalConfiguration;
import sqsaml.org.apache.commons.configuration.SubnodeConfiguration;
import sqsaml.org.apache.commons.configuration.event.ConfigurationErrorListener;
import sqsaml.org.apache.commons.configuration.event.ConfigurationListener;
import sqsaml.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import sqsaml.org.apache.commons.configuration.tree.ConfigurationNode;
import sqsaml.org.apache.commons.configuration.tree.ExpressionEngine;
import sqsaml.org.apache.commons.configuration.tree.NodeCombiner;
import sqsaml.org.apache.commons.lang.text.StrLookup;
import sqsaml.org.apache.commons.lang.text.StrSubstitutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicCombinedConfiguration
extends CombinedConfiguration {
    private static ThreadLocal<Boolean> recursive = new ThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ConcurrentMap<String, CombinedConfiguration> configs = new ConcurrentHashMap<String, CombinedConfiguration>();
    private List<ConfigData> configurations = new ArrayList<ConfigData>();
    private Map<String, AbstractConfiguration> namedConfigurations = new HashMap<String, AbstractConfiguration>();
    private String keyPattern;
    private NodeCombiner nodeCombiner;
    private String loggerName = DynamicCombinedConfiguration.class.getName();
    private StrSubstitutor localSubst = new StrSubstitutor((StrLookup)new ConfigurationInterpolator());

    public DynamicCombinedConfiguration(NodeCombiner comb) {
        this.setNodeCombiner(comb);
        this.setIgnoreReloadExceptions(false);
        this.setLogger(LogFactory.getLog(DynamicCombinedConfiguration.class));
    }

    public DynamicCombinedConfiguration() {
        this.setIgnoreReloadExceptions(false);
        this.setLogger(LogFactory.getLog(DynamicCombinedConfiguration.class));
    }

    public void setKeyPattern(String pattern) {
        this.keyPattern = pattern;
    }

    public String getKeyPattern() {
        return this.keyPattern;
    }

    public void setLoggerName(String name) {
        this.loggerName = name;
    }

    @Override
    public NodeCombiner getNodeCombiner() {
        return this.nodeCombiner;
    }

    @Override
    public void setNodeCombiner(NodeCombiner nodeCombiner) {
        if (nodeCombiner == null) {
            throw new IllegalArgumentException("Node combiner must not be null!");
        }
        this.nodeCombiner = nodeCombiner;
        this.invalidateAll();
    }

    @Override
    public void addConfiguration(AbstractConfiguration config, String name, String at) {
        ConfigData cd = new ConfigData(config, name, at);
        this.configurations.add(cd);
        if (name != null) {
            this.namedConfigurations.put(name, config);
        }
    }

    @Override
    public int getNumberOfConfigurations() {
        return this.configurations.size();
    }

    @Override
    public Configuration getConfiguration(int index) {
        ConfigData cd = this.configurations.get(index);
        return cd.getConfiguration();
    }

    @Override
    public Configuration getConfiguration(String name) {
        return this.namedConfigurations.get(name);
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.namedConfigurations.keySet();
    }

    @Override
    public Configuration removeConfiguration(String name) {
        Configuration conf = this.getConfiguration(name);
        if (conf != null) {
            this.removeConfiguration(conf);
        }
        return conf;
    }

    @Override
    public boolean removeConfiguration(Configuration config) {
        for (int index = 0; index < this.getNumberOfConfigurations(); ++index) {
            if (this.configurations.get(index).getConfiguration() != config) continue;
            this.removeConfigurationAt(index);
        }
        return super.removeConfiguration(config);
    }

    @Override
    public Configuration removeConfigurationAt(int index) {
        ConfigData cd = this.configurations.remove(index);
        if (cd.getName() != null) {
            this.namedConfigurations.remove(cd.getName());
        }
        return super.removeConfigurationAt(index);
    }

    @Override
    public ConfigurationNode getRootNode() {
        return this.getCurrentConfig().getRootNode();
    }

    @Override
    public void setRootNode(ConfigurationNode rootNode) {
        if (this.configs != null) {
            this.getCurrentConfig().setRootNode(rootNode);
        } else {
            super.setRootNode(rootNode);
        }
    }

    @Override
    public void addProperty(String key, Object value) {
        this.getCurrentConfig().addProperty(key, value);
    }

    @Override
    public void clear() {
        if (this.configs != null) {
            this.getCurrentConfig().clear();
        }
    }

    @Override
    public void clearProperty(String key) {
        this.getCurrentConfig().clearProperty(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.getCurrentConfig().containsKey(key);
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.getCurrentConfig().getBigDecimal(key, defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.getCurrentConfig().getBigDecimal(key);
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.getCurrentConfig().getBigInteger(key, defaultValue);
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.getCurrentConfig().getBigInteger(key);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getCurrentConfig().getBoolean(key, defaultValue);
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getCurrentConfig().getBoolean(key, defaultValue);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getCurrentConfig().getBoolean(key);
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        return this.getCurrentConfig().getByte(key, defaultValue);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        return this.getCurrentConfig().getByte(key, defaultValue);
    }

    @Override
    public byte getByte(String key) {
        return this.getCurrentConfig().getByte(key);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.getCurrentConfig().getDouble(key, defaultValue);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        return this.getCurrentConfig().getDouble(key, defaultValue);
    }

    @Override
    public double getDouble(String key) {
        return this.getCurrentConfig().getDouble(key);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return this.getCurrentConfig().getFloat(key, defaultValue);
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        return this.getCurrentConfig().getFloat(key, defaultValue);
    }

    @Override
    public float getFloat(String key) {
        return this.getCurrentConfig().getFloat(key);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.getCurrentConfig().getInt(key, defaultValue);
    }

    @Override
    public int getInt(String key) {
        return this.getCurrentConfig().getInt(key);
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        return this.getCurrentConfig().getInteger(key, defaultValue);
    }

    @Override
    public Iterator<String> getKeys() {
        return this.getCurrentConfig().getKeys();
    }

    @Override
    public Iterator<String> getKeys(String prefix) {
        return this.getCurrentConfig().getKeys(prefix);
    }

    @Override
    public List<Object> getList(String key, List<?> defaultValue) {
        return this.getCurrentConfig().getList(key, defaultValue);
    }

    @Override
    public List<Object> getList(String key) {
        return this.getCurrentConfig().getList(key);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.getCurrentConfig().getLong(key, defaultValue);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return this.getCurrentConfig().getLong(key, defaultValue);
    }

    @Override
    public long getLong(String key) {
        return this.getCurrentConfig().getLong(key);
    }

    @Override
    public Properties getProperties(String key) {
        return this.getCurrentConfig().getProperties(key);
    }

    @Override
    public Object getProperty(String key) {
        return this.getCurrentConfig().getProperty(key);
    }

    @Override
    public short getShort(String key, short defaultValue) {
        return this.getCurrentConfig().getShort(key, defaultValue);
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        return this.getCurrentConfig().getShort(key, defaultValue);
    }

    @Override
    public short getShort(String key) {
        return this.getCurrentConfig().getShort(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.getCurrentConfig().getString(key, defaultValue);
    }

    @Override
    public String getString(String key) {
        return this.getCurrentConfig().getString(key);
    }

    @Override
    public String[] getStringArray(String key) {
        return this.getCurrentConfig().getStringArray(key);
    }

    @Override
    public boolean isEmpty() {
        return this.getCurrentConfig().isEmpty();
    }

    @Override
    public void setProperty(String key, Object value) {
        if (this.configs != null) {
            this.getCurrentConfig().setProperty(key, value);
        }
    }

    @Override
    public Configuration subset(String prefix) {
        return this.getCurrentConfig().subset(prefix);
    }

    @Override
    public HierarchicalConfiguration.Node getRoot() {
        return this.getCurrentConfig().getRoot();
    }

    @Override
    public void setRoot(HierarchicalConfiguration.Node node) {
        if (this.configs != null) {
            this.getCurrentConfig().setRoot(node);
        } else {
            super.setRoot(node);
        }
    }

    @Override
    public ExpressionEngine getExpressionEngine() {
        return super.getExpressionEngine();
    }

    @Override
    public void setExpressionEngine(ExpressionEngine expressionEngine) {
        super.setExpressionEngine(expressionEngine);
    }

    @Override
    public void addNodes(String key, Collection<? extends ConfigurationNode> nodes) {
        this.getCurrentConfig().addNodes(key, nodes);
    }

    @Override
    public SubnodeConfiguration configurationAt(String key, boolean supportUpdates) {
        return this.getCurrentConfig().configurationAt(key, supportUpdates);
    }

    @Override
    public SubnodeConfiguration configurationAt(String key) {
        return this.getCurrentConfig().configurationAt(key);
    }

    @Override
    public List<HierarchicalConfiguration> configurationsAt(String key) {
        return this.getCurrentConfig().configurationsAt(key);
    }

    @Override
    public void clearTree(String key) {
        this.getCurrentConfig().clearTree(key);
    }

    @Override
    public int getMaxIndex(String key) {
        return this.getCurrentConfig().getMaxIndex(key);
    }

    @Override
    public Configuration interpolatedConfiguration() {
        return this.getCurrentConfig().interpolatedConfiguration();
    }

    @Override
    public Configuration getSource(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        return this.getCurrentConfig().getSource(key);
    }

    @Override
    public void addConfigurationListener(ConfigurationListener l) {
        super.addConfigurationListener(l);
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.addConfigurationListener(l);
        }
    }

    @Override
    public boolean removeConfigurationListener(ConfigurationListener l) {
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.removeConfigurationListener(l);
        }
        return super.removeConfigurationListener(l);
    }

    @Override
    public Collection<ConfigurationListener> getConfigurationListeners() {
        return super.getConfigurationListeners();
    }

    @Override
    public void clearConfigurationListeners() {
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.clearConfigurationListeners();
        }
        super.clearConfigurationListeners();
    }

    @Override
    public void addErrorListener(ConfigurationErrorListener l) {
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.addErrorListener(l);
        }
        super.addErrorListener(l);
    }

    @Override
    public boolean removeErrorListener(ConfigurationErrorListener l) {
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.removeErrorListener(l);
        }
        return super.removeErrorListener(l);
    }

    @Override
    public void clearErrorListeners() {
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.clearErrorListeners();
        }
        super.clearErrorListeners();
    }

    @Override
    public Collection<ConfigurationErrorListener> getErrorListeners() {
        return super.getErrorListeners();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public void invalidate() {
        this.getCurrentConfig().invalidate();
    }

    public void invalidateAll() {
        if (this.configs == null) {
            return;
        }
        for (CombinedConfiguration cc : this.configs.values()) {
            cc.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object resolveContainerStore(String key) {
        if (recursive.get().booleanValue()) {
            return null;
        }
        recursive.set(Boolean.TRUE);
        try {
            Object object = super.resolveContainerStore(key);
            return object;
        }
        finally {
            recursive.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CombinedConfiguration getCurrentConfig() {
        String key = this.localSubst.replace(this.keyPattern);
        CombinedConfiguration config = (CombinedConfiguration)this.configs.get(key);
        if (config == null) {
            ConcurrentMap<String, CombinedConfiguration> concurrentMap = this.configs;
            synchronized (concurrentMap) {
                config = (CombinedConfiguration)this.configs.get(key);
                if (config == null) {
                    Log log;
                    config = new CombinedConfiguration(this.getNodeCombiner());
                    if (this.loggerName != null && (log = LogFactory.getLog((String)this.loggerName)) != null) {
                        config.setLogger(log);
                    }
                    config.setIgnoreReloadExceptions(this.isIgnoreReloadExceptions());
                    config.setExpressionEngine(this.getExpressionEngine());
                    config.setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
                    config.setConversionExpressionEngine(this.getConversionExpressionEngine());
                    config.setListDelimiter(this.getListDelimiter());
                    for (ConfigurationErrorListener configurationErrorListener : this.getErrorListeners()) {
                        config.addErrorListener(configurationErrorListener);
                    }
                    for (ConfigurationListener configurationListener : this.getConfigurationListeners()) {
                        config.addConfigurationListener(configurationListener);
                    }
                    config.setForceReloadCheck(this.isForceReloadCheck());
                    for (ConfigData configData : this.configurations) {
                        config.addConfiguration(configData.getConfiguration(), configData.getName(), configData.getAt());
                    }
                    this.configs.put(key, config);
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Returning config for " + key + ": " + config));
        }
        return config;
    }

    static class ConfigData {
        private AbstractConfiguration configuration;
        private String name;
        private String at;

        public ConfigData(AbstractConfiguration config, String n, String at) {
            this.configuration = config;
            this.name = n;
            this.at = at;
        }

        public AbstractConfiguration getConfiguration() {
            return this.configuration;
        }

        public String getName() {
            return this.name;
        }

        public String getAt() {
            return this.at;
        }
    }
}

