/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.nu.xom;

import java.io.UnsupportedEncodingException;
import sqsaml.nu.xom.MalformedURIException;
import sqsaml.nu.xom.Verifier;

class URIUtil {
    URIUtil() {
    }

    static boolean isOpaque(String string) {
        int n = string.indexOf(58);
        if (string.substring(n + 1).startsWith("/")) {
            return false;
        }
        return Verifier.isAlpha(string.charAt(0));
    }

    static boolean isAbsolute(String string) {
        int n = string.indexOf(58);
        return n >= 1;
    }

    static String absolutize(String string, String string2) {
        if ("".equals(string) || string == null) {
            return string2;
        }
        ParsedURI parsedURI = new ParsedURI(string);
        if (parsedURI.path.endsWith("/..")) {
            parsedURI.path = parsedURI.path + '/';
        }
        ParsedURI parsedURI2 = new ParsedURI(string2);
        ParsedURI parsedURI3 = new ParsedURI();
        if (parsedURI2.authority != null) {
            parsedURI3.authority = parsedURI2.authority;
            parsedURI3.query = parsedURI2.query;
            parsedURI3.path = URIUtil.removeDotSegments(parsedURI2.path);
        } else {
            if ("".equals(parsedURI2.path)) {
                parsedURI3.path = parsedURI.path;
                parsedURI3.query = parsedURI2.query != null ? parsedURI2.query : parsedURI.query;
            } else {
                if (parsedURI2.path.startsWith("/")) {
                    parsedURI3.path = URIUtil.removeDotSegments(parsedURI2.path);
                } else {
                    parsedURI3.path = URIUtil.merge(parsedURI, parsedURI2.path);
                    parsedURI3.path = URIUtil.removeDotSegments(parsedURI3.path);
                }
                parsedURI3.query = parsedURI2.query;
            }
            parsedURI3.authority = parsedURI.authority;
        }
        parsedURI3.scheme = parsedURI.scheme;
        parsedURI3.fragment = parsedURI2.fragment;
        return parsedURI3.toString();
    }

    private static String merge(ParsedURI parsedURI, String string) {
        if (parsedURI.authority != null && "".equals(parsedURI.path) && !"".equals(parsedURI.authority)) {
            return "/" + string;
        }
        int n = parsedURI.path.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        String string2 = parsedURI.path.substring(0, n + 1);
        return string2 + string;
    }

    static String removeDotSegments(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        while (string.length() > 0) {
            int n;
            if (string.startsWith("/./")) {
                string = '/' + string.substring(3);
                continue;
            }
            if (string.equals("/.")) {
                string = "/";
                continue;
            }
            if (string.startsWith("/../")) {
                string = '/' + string.substring(4);
                n = stringBuilder.toString().lastIndexOf(47);
                if (n == -1) continue;
                stringBuilder.setLength(n);
                continue;
            }
            if (string.equals("/..")) {
                string = "/";
                n = stringBuilder.toString().lastIndexOf(47);
                if (n == -1) continue;
                stringBuilder.setLength(n);
                continue;
            }
            n = string.indexOf(47);
            if (n == 0) {
                n = string.indexOf(47, 1);
            }
            if (n == -1) {
                stringBuilder.append(string);
                string = "";
                continue;
            }
            stringBuilder.append(string.substring(0, n));
            string = string.substring(n);
        }
        return stringBuilder.toString();
    }

    static String toURI(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block97: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    stringBuilder.append("%20");
                    continue block97;
                }
                case '!': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '\"': {
                    stringBuilder.append("%22");
                    continue block97;
                }
                case '#': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '$': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '%': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '&': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '\'': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '(': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case ')': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '*': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '+': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case ',': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '-': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '.': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '/': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '0': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '1': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '2': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '3': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '4': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '5': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '6': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '7': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '8': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '9': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case ':': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case ';': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '<': {
                    stringBuilder.append("%3C");
                    continue block97;
                }
                case '=': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '>': {
                    stringBuilder.append("%3E");
                    continue block97;
                }
                case '?': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '@': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'A': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'B': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'C': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'D': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'E': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'F': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'G': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'H': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'I': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'J': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'K': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'L': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'M': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'N': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'O': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'P': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'Q': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'R': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'S': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'T': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'U': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'V': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'W': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'X': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'Y': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'Z': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '[': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '\\': {
                    stringBuilder.append("%5C");
                    continue block97;
                }
                case ']': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '^': {
                    stringBuilder.append("%5E");
                    continue block97;
                }
                case '_': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '`': {
                    stringBuilder.append("%60");
                    continue block97;
                }
                case 'a': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'b': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'c': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'd': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'e': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'f': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'g': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'h': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'i': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'j': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'k': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'l': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'm': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'n': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'o': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'p': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'q': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'r': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 's': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 't': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'u': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'v': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'w': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'x': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'y': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case 'z': {
                    stringBuilder.append(c);
                    continue block97;
                }
                case '{': {
                    stringBuilder.append("%7B");
                    continue block97;
                }
                case '|': {
                    stringBuilder.append("%7C");
                    continue block97;
                }
                case '}': {
                    stringBuilder.append("%7D");
                    continue block97;
                }
                case '~': {
                    stringBuilder.append(c);
                    continue block97;
                }
                default: {
                    stringBuilder.append(URIUtil.percentEscape(c));
                }
            }
        }
        return stringBuilder.toString();
    }

    static String percentEscape(char c) {
        StringBuilder stringBuilder = new StringBuilder(3);
        String string = String.valueOf(c);
        try {
            byte[] byArray = string.getBytes("UTF8");
            for (int i = 0; i < byArray.length; ++i) {
                stringBuilder.append('%');
                String string2 = Integer.toHexString(byArray[i]).toUpperCase();
                if (c < '\u0010') {
                    stringBuilder.append('0');
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append(string2.substring(string2.length() - 2));
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Broken VM: does not recognize UTF-8 encoding");
        }
    }

    static String relativize(String string, String string2) {
        ParsedURI parsedURI = new ParsedURI(string);
        ParsedURI parsedURI2 = new ParsedURI(string2);
        parsedURI.path = URIUtil.removeDotSegments(parsedURI.path);
        if (parsedURI.scheme.equals(parsedURI2.scheme) && parsedURI.authority.equals(parsedURI2.authority)) {
            String string3 = parsedURI.path;
            String string4 = parsedURI2.path;
            while (string3.length() > 1) {
                if (!string4.startsWith(string3 = string3.substring(0, string3.lastIndexOf(47)))) continue;
                return string4.substring(string3.length() + 1);
            }
            return string4;
        }
        return string2;
    }

    static class ParsedURI {
        String scheme;
        String schemeSpecificPart;
        String query;
        String fragment;
        String authority;
        String path = "";

        ParsedURI(String string) {
            int n = string.indexOf(58);
            int n2 = string.lastIndexOf(35);
            int n3 = n2 == -1 ? string.indexOf(63) : string.substring(0, n2).indexOf(63);
            if (n != -1) {
                this.scheme = string.substring(0, n);
            }
            if (n3 == -1 && n2 == -1) {
                this.schemeSpecificPart = string.substring(n + 1);
            } else if (n3 != -1) {
                if (n3 < n) {
                    MalformedURIException malformedURIException = new MalformedURIException("Unparseable URI");
                    malformedURIException.setData(string);
                    throw malformedURIException;
                }
                this.schemeSpecificPart = string.substring(n + 1, n3);
            } else {
                if (n2 < n) {
                    MalformedURIException malformedURIException = new MalformedURIException("Unparseable URI");
                    malformedURIException.setData(string);
                    throw malformedURIException;
                }
                this.schemeSpecificPart = string.substring(n + 1, n2);
            }
            if (n2 != -1) {
                this.fragment = string.substring(n2 + 1);
            }
            if (n3 != -1) {
                this.query = n2 == -1 ? string.substring(n3 + 1) : string.substring(n3 + 1, n2);
            }
            if (this.schemeSpecificPart.startsWith("//")) {
                int n4 = 2;
                int n5 = this.schemeSpecificPart.indexOf(47, n4);
                if (n5 == -1) {
                    this.authority = this.schemeSpecificPart.substring(2);
                    this.path = "";
                } else {
                    this.authority = this.schemeSpecificPart.substring(n4, n5);
                    this.path = this.schemeSpecificPart.substring(n5);
                }
            } else {
                this.path = this.schemeSpecificPart;
            }
        }

        ParsedURI() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(30);
            if (this.scheme != null) {
                stringBuilder.append(this.scheme);
                stringBuilder.append(':');
            }
            if (this.schemeSpecificPart != null) {
                stringBuilder.append(this.schemeSpecificPart);
            } else {
                stringBuilder.append("//");
                if (this.authority != null) {
                    stringBuilder.append(this.authority);
                }
                stringBuilder.append(this.path);
            }
            if (this.query != null) {
                stringBuilder.append('?');
                stringBuilder.append(this.query);
            }
            if (this.fragment != null) {
                stringBuilder.append('#');
                stringBuilder.append(this.fragment);
            }
            return stringBuilder.toString();
        }
    }
}

