/*
 * Decompiled with CFR 0.152.
 */
package sqsaml.nu.xom;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import sqsaml.nu.xom.ASCIIWriter;
import sqsaml.nu.xom.GenericWriter;
import sqsaml.nu.xom.ISOArabicWriter;
import sqsaml.nu.xom.ISOCyrillicWriter;
import sqsaml.nu.xom.ISOGreekWriter;
import sqsaml.nu.xom.ISOHebrewWriter;
import sqsaml.nu.xom.ISOThaiWriter;
import sqsaml.nu.xom.Latin10Writer;
import sqsaml.nu.xom.Latin1Writer;
import sqsaml.nu.xom.Latin2Writer;
import sqsaml.nu.xom.Latin3Writer;
import sqsaml.nu.xom.Latin4Writer;
import sqsaml.nu.xom.Latin5Writer;
import sqsaml.nu.xom.Latin6Writer;
import sqsaml.nu.xom.Latin7Writer;
import sqsaml.nu.xom.Latin8Writer;
import sqsaml.nu.xom.Latin9Writer;
import sqsaml.nu.xom.TextWriter;
import sqsaml.nu.xom.UCSWriter;
import sqsaml.nu.xom.UnicodeWriter;

class TextWriterFactory {
    TextWriterFactory() {
    }

    public static TextWriter getTextWriter(Writer writer, String string) {
        String string2 = string.toUpperCase(Locale.ENGLISH);
        if (string2.startsWith("UTF") || string2.startsWith("UNICODE")) {
            return new UnicodeWriter(writer, string);
        }
        if (string2.startsWith("ISO-10646-UCS") || string2.startsWith("UCS") || string2.equals("GB18030")) {
            return new UCSWriter(writer, string);
        }
        if (string2.equals("ISO-8859-1")) {
            return new Latin1Writer(writer, string);
        }
        if (string2.equals("ISO-8859-2")) {
            return new Latin2Writer(writer, string2);
        }
        if (string2.equals("ISO-8859-3")) {
            return new Latin3Writer(writer, string2);
        }
        if (string2.equals("ISO-8859-4")) {
            return new Latin4Writer(writer, string2);
        }
        if (string2.equals("ISO-8859-5")) {
            return new ISOCyrillicWriter(writer, string2);
        }
        if (string2.equals("ISO-8859-6")) {
            return new ISOArabicWriter(writer, string2);
        }
        if (string2.equals("ISO-8859-7")) {
            return new ISOGreekWriter(writer, string2);
        }
        if (string2.equals("ISO-8859-8")) {
            return new ISOHebrewWriter(writer, string2);
        }
        if (string2.equals("ISO-8859-9") || string2.equals("EBCDIC-CP-TR") || string2.equals("CP1037")) {
            return new Latin5Writer(writer, string2);
        }
        if (string.equals("ISO-8859-10")) {
            return new Latin6Writer(writer, string);
        }
        if (string2.equals("ISO-8859-11") || string2.equals("TIS-620") || string2.equals("TIS620")) {
            return new ISOThaiWriter(writer, string2);
        }
        if (string2.equals("ISO-8859-13")) {
            return new Latin7Writer(writer, string2);
        }
        if (string.equals("ISO-8859-14")) {
            return new Latin8Writer(writer, string);
        }
        if (string2.equals("ISO-8859-15")) {
            return new Latin9Writer(writer, string2);
        }
        if (string.equals("ISO-8859-16")) {
            return new Latin10Writer(writer, string);
        }
        if (string2.endsWith("ASCII")) {
            return new ASCIIWriter(writer, string2);
        }
        if (string2.equals("IBM037") || string2.equals("CP037") || string2.equals("EBCDIC-CP-US") || string2.equals("EBCDIC-CP-CA") || string2.equals("EBCDIC-CP-WA") || string2.equals("EBCDIC-CP-NL") || string2.equals("CSIBM037")) {
            return new Latin1Writer(writer, string2);
        }
        try {
            return new GenericWriter(writer, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new ASCIIWriter(writer, string);
        }
    }
}

