/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml.properties;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.Errors;
import org.squashtest.tm.plugin.saml.properties.IDPProperties;
import org.squashtest.tm.plugin.saml.properties.KeystoreProperties;
import org.squashtest.tm.plugin.saml.properties.MetadataProperties;
import org.squashtest.tm.plugin.saml.properties.SAMLProperties;
import org.squashtest.tm.plugin.saml.properties.SPProperties;

class PropertiesValidator {
    private static final String NOT_BLANK_CODE = "not blank";
    private static final String NOT_BLANK_MSG = "must not be empty";
    private static final String URL_PROTO_INVALID_CODE = "invalid protocol";
    private static final String URL_PROTO_INVALID_MSG = "that property doesn't allow protocol : %s";
    private static final String UNKNOWN_VALUE_CODE = "unknown value";
    private static final String UNKNOWN_VALUE_MSG = "values must be one of : ";
    private static final String MISSING_DATA_CODE = "additional data required";
    private Errors errors;
    private SAMLProperties props;

    PropertiesValidator(Object object, Errors errors) {
        this.errors = errors;
        this.props = (SAMLProperties)object;
    }

    public void validate() {
        this.validateKeystore();
        this.validateIdp();
        this.validateSp();
    }

    private void validateKeystore() {
        KeystoreProperties keystore = this.props.getKeystore();
        String url = keystore.getUrl();
        this.rejectIfPathFormatInvalid("keystore.url", url, "file");
        this.rejectIfEmpty("keystore.password", keystore.getPassword());
        this.rejectIfEmpty("keystore.defaultKey", keystore.getDefaultKey());
        Map<String, String> credentials = keystore.getCredentials();
        if (credentials == null || credentials.isEmpty()) {
            this.rejectValue("keystore.credentials", NOT_BLANK_CODE, NOT_BLANK_MSG, new String[0]);
        } else {
            String defKey = keystore.getDefaultKey();
            if (!keystore.getCredentials().keySet().contains(defKey)) {
                this.rejectValue("keystore.defaultKey", MISSING_DATA_CODE, "configured default key is '%s', but was not configured in keystore.credentials (ie missing entry keystore.credentials.%s)", defKey, defKey);
            }
        }
    }

    private void validateIdp() {
        IDPProperties idp = this.props.getIdp();
        MetadataProperties meta = idp.getMetadata();
        String url = meta != null ? meta.getUrl() : "";
        this.rejectIfPathFormatInvalid("idp.metadata.url", url, "file", "http", "https");
    }

    private void validateSp() {
        SPProperties sp = this.props.getSp();
        MetadataProperties meta = sp.getMetadata();
        String url = meta != null ? meta.getUrl() : "";
        this.rejectIfPathFormatInvalid("sp.metadata.url", url, "file", "http", "https");
        String secProfile = sp.getSignatureSecurityProfile();
        this.rejectIfUnknown("sp.signatureSecurityProfile", secProfile, "metaiop", "pkix");
        String sslSecProfile = sp.getSslSecurityProfile();
        this.rejectIfUnknown("sp.sslSecurityProfile", sslSecProfile, "metaiop", "pkix");
        String hostVerif = sp.getSslHostnameVerification();
        this.rejectIfUnknown("sp.hostnameVerification", hostVerif, "default", "defaultAndLocalhost", "strict", "allowAll");
    }

    private void rejectIfPathFormatInvalid(String property, String toTest, String ... protocols) {
        if (StringUtils.isBlank((CharSequence)toTest)) {
            this.errors.rejectValue(property, NOT_BLANK_CODE, NOT_BLANK_MSG);
            return;
        }
        Pattern p = Pattern.compile("^(\\w+)://.*");
        Matcher m = p.matcher(toTest);
        if (m.matches()) {
            String protocol = m.group(1);
            boolean valid = false;
            int i = 0;
            while (i < protocols.length) {
                if (protocol.equalsIgnoreCase(protocols[i])) {
                    valid = true;
                    break;
                }
                ++i;
            }
            if (!valid) {
                this.rejectValue(property, URL_PROTO_INVALID_CODE, URL_PROTO_INVALID_MSG, protocol);
            }
        }
    }

    private void rejectIfEmpty(String property, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.errors.rejectValue(property, NOT_BLANK_CODE, NOT_BLANK_MSG);
        }
    }

    private void rejectIfUnknown(String property, String toTest, String ... allowed) {
        if (toTest != null) {
            int i = 0;
            while (i < allowed.length) {
                if (toTest.equals(allowed[i])) {
                    return;
                }
                ++i;
            }
        }
        StringBuilder msgBuilder = new StringBuilder(UNKNOWN_VALUE_MSG);
        msgBuilder.append(" '" + allowed[0] + "'");
        int i = 1;
        while (i < allowed.length) {
            msgBuilder.append(", '" + allowed[i] + "'");
            ++i;
        }
        this.errors.rejectValue(property, UNKNOWN_VALUE_CODE, msgBuilder.toString());
    }

    private void rejectValue(String propertyName, String errorCode, String message, String ... arguments) {
        String formatted = String.format(message, arguments);
        this.errors.rejectValue(propertyName, errorCode, formatted);
    }
}

