/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.saml;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.opensaml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.squashtest.tm.plugin.saml.beans.ExtraAccountInformation;
import org.squashtest.tm.plugin.saml.beans.ExtraAccountInformationUser;
import org.squashtest.tm.plugin.saml.exception.DisabledUserException;
import org.squashtest.tm.plugin.saml.properties.UserMappingProperties;
import sqsaml.org.springframework.security.saml.SAMLCredential;
import sqsaml.org.springframework.security.saml.userdetails.SAMLUserDetailsService;

public class SquashSAMLUserDetailsService
implements SAMLUserDetailsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashSAMLUserDetailsService.class);
    private static final String EMPTY_PASSWORD = "(not available)";
    private final UserMappingProperties userMapping;
    @Inject
    private UserDetailsService manager;

    public SquashSAMLUserDetailsService(UserMappingProperties userMapping) {
        this.userMapping = userMapping;
    }

    @Override
    public Object loadUserBySAML(SAMLCredential credential) throws UsernameNotFoundException {
        String username = this.findUsername(credential);
        LOGGER.debug("Fetching user details for user {}", (Object)username);
        try {
            UserDetails user = this.manager.loadUserByUsername(username);
            if (!user.isEnabled()) {
                throw new DisabledUserException("The authentication attempt has failed because the user account associated with this login request has been disabled. Please contact the system administrator for assistance or to reactivate your account.");
            }
            LOGGER.debug("found user details for user {}", (Object)username);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("user details for {} are : ", (Object)username);
                LOGGER.trace(user.toString());
            }
            return user;
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            return this.handleNewUser(username, credential);
        }
    }

    private String findUsername(SAMLCredential credential) {
        String username;
        if (this.userMapping.isMappedAlternateUsername()) {
            String attrName = this.userMapping.getAlternateUsername();
            LOGGER.debug("looking for alternate username instead of NameID, using SAML assertion attribute '{}'", (Object)attrName);
            username = credential.getAttributeAsString(attrName);
        } else {
            LOGGER.debug("using the NameID as Squash username");
            username = credential.getNameID().getValue();
        }
        return username;
    }

    private User handleNewUser(String username, SAMLCredential credential) {
        LOGGER.debug("user details not found for user {}, returning stub user with default permissions", (Object)username);
        User user = null;
        List authorities = Collections.emptyList();
        if (this.userMapping.requiresExtraAttributes()) {
            ExtraAccountInformation extraInformation = this.extractInformation(username, credential);
            user = new ExtraAccountInformationUser(username, EMPTY_PASSWORD, authorities, extraInformation);
        } else {
            user = new User(username, EMPTY_PASSWORD, authorities);
        }
        return user;
    }

    private ExtraAccountInformation extractInformation(String username, SAMLCredential credential) {
        String attr;
        String firstName = "";
        String lastName = "";
        String email = "";
        LOGGER.debug("retrieving extra account information from SAML assertion");
        this.logAvailableAttributes(credential);
        if (this.userMapping.getFirstName() != null) {
            attr = this.userMapping.getFirstName();
            LOGGER.trace("looking for firstName in attribute '{}'", (Object)attr);
            firstName = credential.getAttributeAsString(attr);
            LOGGER.trace("firstName : '{}'", (Object)firstName);
        }
        if (this.userMapping.getLastName() != null) {
            attr = this.userMapping.getLastName();
            LOGGER.trace("looking for lastName in attribute '{}'", (Object)attr);
            lastName = credential.getAttributeAsString(attr);
            LOGGER.trace("lastName : '{}'", (Object)lastName);
        }
        if (this.userMapping.getEmail() != null) {
            attr = this.userMapping.getEmail();
            LOGGER.trace("looking for email in attribute '{}'", (Object)attr);
            email = credential.getAttributeAsString(attr);
            LOGGER.trace("email : '{}'", (Object)email);
        }
        if (firstName == null || lastName == null || email == null) {
            this.warnEmptyAttributes();
        }
        if (StringUtils.isBlank((CharSequence)lastName)) {
            LOGGER.trace("empty lastname found, however it cannot be null. Using the username instead.");
            lastName = username;
        }
        return new ExtraAccountInformation(firstName, lastName, email);
    }

    private void logAvailableAttributes(SAMLCredential credential) {
        if (LOGGER.isTraceEnabled()) {
            List<String> formalNames = credential.getAttributes().stream().map(this::getFormalName).toList();
            List<String> friendlyNames = credential.getAttributes().stream().map(this::getFriendlyName).toList();
            LOGGER.trace("attributes found in assertion AttributeStatement clause :");
            LOGGER.trace("\tnames : {}", formalNames);
            LOGGER.trace("\tfriendly names : {}", friendlyNames);
        }
    }

    private String getFormalName(Attribute attr) {
        return StringUtils.defaultString((String)attr.getName(), (String)"undefined");
    }

    private String getFriendlyName(Attribute attr) {
        return StringUtils.defaultString((String)attr.getFriendlyName(), (String)"undefined");
    }

    private void warnEmptyAttributes() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.warn("some requested attributes were not found in the assertion, please review the available attributes listed above then check your configuration");
        } else {
            LOGGER.warn("some requested attributes were not found in the assertion, please enable trace level for the logger '{}' to know more about what went wrong", (Object)this.getClass().getPackage().getName());
        }
    }
}

