/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransport;
import org.opensaml.ws.transport.http.httpclient.OutputStreamRequestEntity;
import org.opensaml.xml.security.credential.Credential;
import sqsaml.org.apache.commons.httpclient.HttpVersion;
import sqsaml.org.apache.commons.httpclient.methods.PostMethod;
import sqsaml.org.apache.commons.httpclient.params.HttpMethodParams;

public class HttpClientOutTransport
implements HTTPOutTransport {
    private final PostMethod postMethod;

    public HttpClientOutTransport(PostMethod postMethod) {
        this.postMethod = postMethod;
    }

    @Override
    public void setVersion(HTTPTransport.HTTP_VERSION http_version) {
        HttpMethodParams params = this.postMethod.getParams();
        switch (http_version) {
            case HTTP1_0: {
                params.setParameter("http.protocol.version", HttpVersion.HTTP_1_0);
                break;
            }
            case HTTP1_1: {
                params.setParameter("http.protocol.version", HttpVersion.HTTP_1_1);
            }
        }
    }

    @Override
    public void setHeader(String s, String s1) {
        this.postMethod.setRequestHeader(s, s1);
    }

    @Override
    public void addParameter(String s, String s1) {
    }

    @Override
    public void setStatusCode(int i) {
    }

    @Override
    public void sendRedirect(String s) {
    }

    @Override
    public void setAttribute(String s, Object o) {
    }

    @Override
    public void setCharacterEncoding(String s) {
        this.postMethod.getParams().setParameter("http.protocol.content-charset", s);
    }

    @Override
    public OutputStream getOutgoingStream() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamRequestEntity requestEntity = new OutputStreamRequestEntity(outputStream);
        this.postMethod.setRequestEntity(requestEntity);
        return outputStream;
    }

    @Override
    public Object getAttribute(String s) {
        return null;
    }

    @Override
    public String getCharacterEncoding() {
        return this.postMethod.getParameter("http.protocol.content-charset").getValue();
    }

    @Override
    public Credential getLocalCredential() {
        return null;
    }

    @Override
    public Credential getPeerCredential() {
        return null;
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }

    @Override
    public void setAuthenticated(boolean b) {
    }

    @Override
    public boolean isConfidential() {
        return false;
    }

    @Override
    public void setConfidential(boolean b) {
    }

    @Override
    public boolean isIntegrityProtected() {
        return false;
    }

    @Override
    public void setIntegrityProtected(boolean b) {
    }

    @Override
    public String getHeaderValue(String s) {
        return this.postMethod.getRequestHeader(s).getValue();
    }

    @Override
    public String getHTTPMethod() {
        return this.postMethod.getParameter("http.protocol.version").getValue();
    }

    @Override
    public int getStatusCode() {
        return -1;
    }

    @Override
    public String getParameterValue(String s) {
        return null;
    }

    @Override
    public List<String> getParameterValues(String s) {
        return null;
    }

    @Override
    public HTTPTransport.HTTP_VERSION getVersion() {
        HttpVersion httpVersion = (HttpVersion)this.postMethod.getParams().getParameter("http.protocol.version");
        if (httpVersion == HttpVersion.HTTP_1_1) {
            return HTTPTransport.HTTP_VERSION.HTTP1_1;
        }
        return HTTPTransport.HTTP_VERSION.HTTP1_0;
    }
}

