/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.NoteProcessInfo;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.creation.IssueNoteBatchCreationOrchestrator;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.update.IssueNoteBatchUpdateOrchestrator;

@Component
@Transactional(readOnly=true)
public class GitLabNoteBatchOrchestrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabNoteBatchOrchestrator.class);
    private final IssueNoteBatchCreationOrchestrator batchCreator = new IssueNoteBatchCreationOrchestrator();
    private final IssueNoteBatchUpdateOrchestrator batchUpdater = new IssueNoteBatchUpdateOrchestrator();

    public BatchProcessResult processNotes(GitLabClient client, List<NoteProcessInfo> noteProcessInfos) {
        List<NoteProcessInfo> toCreate = noteProcessInfos.stream().filter(NoteProcessInfo::isCreation).collect(Collectors.toList());
        LOGGER.trace("Processing {} notes to create", (Object)toCreate.size());
        IssueNoteBatchCreationOrchestrator.BatchCreationResult batchCreationResult = this.batchCreator.createNotes(client, toCreate);
        List<NoteProcessInfo> toUpdate = noteProcessInfos.stream().filter(NoteProcessInfo::isUpdate).collect(Collectors.toList());
        LOGGER.trace("Processing {} notes to update", (Object)toUpdate.size());
        IssueNoteBatchUpdateOrchestrator.BatchUpdateResult batchUpdateResult = this.batchUpdater.updateNotes(client, toUpdate);
        return new BatchProcessResult(batchCreationResult, batchUpdateResult);
    }

    public static final class BatchProcessResult {
        public final IssueNoteBatchCreationOrchestrator.BatchCreationResult batchCreationResult;
        public final IssueNoteBatchUpdateOrchestrator.BatchUpdateResult batchUpdateResult;

        public BatchProcessResult(IssueNoteBatchCreationOrchestrator.BatchCreationResult batchCreationResult, IssueNoteBatchUpdateOrchestrator.BatchUpdateResult batchUpdateResult) {
            this.batchCreationResult = batchCreationResult;
            this.batchUpdateResult = batchUpdateResult;
        }
    }
}

