/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;

@Service(value="org.squashtest.tm.plugin.xsquash4gitlab.ReportingNoteFormatter")
public class ReportingNoteFormatter {
    private static final String DATA_PATH_FORMAT = "./xsquash4gitlab-note-template_%s.md";
    private static final String SUBSTITUTOR_PREFIX = "{{";
    private static final String SUBSTITUTOR_SUFFIX = "}}";
    private final EnumMap<LocaleCode, String> templateByLocaleCode = new EnumMap(LocaleCode.class);

    public String formatReportNote(NoteParameters parameters, LocaleCode localeCode) {
        StrSubstitutor sub = new StrSubstitutor(parameters.raw(), SUBSTITUTOR_PREFIX, SUBSTITUTOR_SUFFIX);
        return sub.replace(this.templateByLocaleCode.get((Object)localeCode));
    }

    @PostConstruct
    public void loadReportNoteTemplates() {
        this.templateByLocaleCode.clear();
        Arrays.stream(LocaleCode.values()).forEach(localeCode -> {
            try {
                String resourcePath = String.format(DATA_PATH_FORMAT, localeCode.fileNameSuffix);
                Resource resource = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader()).getResource(resourcePath);
                String fileContent = new String(resource.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
                this.templateByLocaleCode.put((LocaleCode)((Object)localeCode), fileContent);
            }
            catch (IOException ioException) {
                throw new IllegalStateException(String.format("Error while loading the report note template for locale %s. Make sure the template file exists.", localeCode.fileNameSuffix), ioException);
            }
        });
    }

    public static enum LocaleCode {
        FR("fr"),
        EN("en");

        public final String fileNameSuffix;

        private LocaleCode(String fileNameSuffix) {
            this.fileNameSuffix = fileNameSuffix;
        }
    }

    static class NoteParameters {
        private final Map<String, String> values = new HashMap<String, String>();

        public NoteParameters(String statusEmoji, String statusText, String redactionRatio, String verificationRatio, String validationRatio, String links, String tmSignature) {
            this.values.put("statusEmoji", statusEmoji);
            this.values.put("statusText", statusText);
            this.values.put("redactionRatio", redactionRatio);
            this.values.put("verificationRatio", verificationRatio);
            this.values.put("validationRatio", validationRatio);
            this.values.put("links", links);
            this.values.put("tmSignature", tmSignature);
        }

        public Map<String, String> raw() {
            return this.values;
        }
    }
}

