/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.reporting;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.plugin.xsquash4gitlab.debug.DebugTimer;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabNote;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClient;
import org.squashtest.tm.plugin.xsquash4gitlab.graphql.client.GitLabClientProvider;
import org.squashtest.tm.plugin.xsquash4gitlab.repository.PluginRequirementDao;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationDisplayService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.ConfigurationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.GitLabIssueCollector;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.GitLabReportingLocaleHelper;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.GitLabReportingService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.batch.NoteProcessInfo;
import org.squashtest.tm.plugin.xsquash4gitlab.service.reporting.scheduling.GitLabReportingScheduler;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatistics;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatisticsDictionary;
import org.squashtest.tm.service.statistics.testingstatus.RemoteTestingStatusService;
import xsquash4gitlab.org.jetbrains.annotations.NotNull;

@Service
@Transactional(readOnly=true)
public class GitLabReportingServiceImpl
implements GitLabReportingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitLabReportingServiceImpl.class);
    private final PluginRequirementDao pluginRequirementDao;
    private final GitLabClientProvider gitLabClientProvider;
    private final GitLabReportingLocaleHelper gitLabReportingLocaleHelper;
    private final ConfigurationService configurationService;
    private final GitLabReportingScheduler reportingScheduler;
    private final RemoteTestingStatusService remoteTestingStatusService;
    private final ConfigurationDisplayService configurationDisplayService;
    @PersistenceContext
    private EntityManager entityManager;

    public GitLabReportingServiceImpl(PluginRequirementDao pluginRequirementDao, GitLabClientProvider gitLabClientProvider, GitLabReportingLocaleHelper gitLabReportingLocaleHelper, ConfigurationService configurationService, GitLabReportingScheduler reportingScheduler, RemoteTestingStatusService remoteTestingStatusService, ConfigurationDisplayService configurationDisplayService) {
        this.pluginRequirementDao = pluginRequirementDao;
        this.gitLabClientProvider = gitLabClientProvider;
        this.gitLabReportingLocaleHelper = gitLabReportingLocaleHelper;
        this.configurationService = configurationService;
        this.reportingScheduler = reportingScheduler;
        this.remoteTestingStatusService = remoteTestingStatusService;
        this.configurationDisplayService = configurationDisplayService;
    }

    @Override
    public void performReporting(List<Long> synchronisationIds, GitLabIssueCollector.ReadOnly collectedIssues) {
        if (!this.configurationDisplayService.isCallbackUrlSet()) {
            LOGGER.warn("TM public URL was not set. Reporting will be skipped");
            return;
        }
        List<RemoteSynchronisation> synchronisations = synchronisationIds.stream().map(id -> (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, id)).filter(Objects::nonNull).filter(RemoteSynchronisation::isSynchronisationEnable).toList();
        if (synchronisations.isEmpty()) {
            return;
        }
        RemoteRequirementStatisticsDictionary remoteRequirementStatisticsDictionary = this.remoteTestingStatusService.getRemoteRequirementStatisticsDictionary("squash.tm.plugin.xsquash4gitlab");
        DebugTimer.mark("Collected stats. About to perform reporting.");
        HashMap<GitLabClient, Set<NoteProcessInfo>> noteProcessInfosByClient = new HashMap<GitLabClient, Set<NoteProcessInfo>>();
        for (RemoteSynchronisation remoteSynchronisation : synchronisations) {
            boolean isTestReportingDisabled;
            boolean isSynchronisationDisabled = !remoteSynchronisation.isSynchronisationEnable();
            boolean bl = isTestReportingDisabled = !this.configurationService.isTestReportingEnabled(remoteSynchronisation.getProject().getId());
            if (isSynchronisationDisabled || isTestReportingDisabled) continue;
            try {
                GitLabClient client = this.gitLabClientProvider.getGitLabClient(remoteSynchronisation.getServer().getId());
                List<NoteProcessInfo> noteProcessInfos = this.prepareReportingForSynchronisation(remoteSynchronisation, remoteRequirementStatisticsDictionary, collectedIssues, client);
                if (noteProcessInfos.isEmpty()) continue;
                noteProcessInfosByClient.computeIfAbsent(client, k -> new HashSet()).addAll(noteProcessInfos);
            }
            catch (ActionException | DomainException exception) {
                LOGGER.error(MessageFormat.format("Could not prepare note reporting for synchronization #{0}.", remoteSynchronisation.getId()), exception);
            }
        }
        if (!noteProcessInfosByClient.isEmpty()) {
            this.reportingScheduler.collectNoteProcessInfos(noteProcessInfosByClient);
        }
        DebugTimer.mark("Finished reporting.");
    }

    private List<NoteProcessInfo> prepareReportingForSynchronisation(RemoteSynchronisation remoteSynchronisation, RemoteRequirementStatisticsDictionary statisticsDictionary, GitLabIssueCollector.ReadOnly collectedIssues, GitLabClient client) {
        List<String> keys2 = this.pluginRequirementDao.findAllSynchronisedKeys(remoteSynchronisation.getId());
        Long serverId = remoteSynchronisation.getServer().getId();
        return keys2.stream().map(key -> this.prepareReportingForRemoteIssue(statisticsDictionary, serverId, (String)key, collectedIssues, client)).filter(Objects::nonNull).toList();
    }

    private NoteProcessInfo prepareReportingForRemoteIssue(RemoteRequirementStatisticsDictionary statisticsDictionary, Long serverId, String issueRemoteKey, GitLabIssueCollector.ReadOnly collectedIssues, GitLabClient client) {
        RemoteRequirementStatistics stats = statisticsDictionary.getMergedStatistics(serverId, issueRemoteKey);
        Set reqIds = statisticsDictionary.getRequirementIdsForRemote(serverId, issueRemoteKey);
        String issueGlobalId = "gid://gitlab/Issue/" + issueRemoteKey;
        Optional<GitLabIssue> collectedGitLabIssue = collectedIssues.getIssue(issueGlobalId);
        if (collectedGitLabIssue.isPresent()) {
            GitLabIssue gitLabIssue = collectedGitLabIssue.get();
            Optional<GitLabNote> existingNote = this.findExistingReportingNote(gitLabIssue, this.gitLabReportingLocaleHelper.getTmSignature(), client);
            String noteBody = this.gitLabReportingLocaleHelper.buildReportNote(stats, issueRemoteKey, reqIds);
            if (existingNote.isPresent()) {
                if (this.noteBodyChanged(existingNote.get().getBody(), noteBody)) {
                    return NoteProcessInfo.forUpdate(gitLabIssue.getGlobalId(), noteBody, existingNote.get().getGlobalId());
                }
                return null;
            }
            return NoteProcessInfo.forCreation(gitLabIssue.getGlobalId(), noteBody);
        }
        return null;
    }

    private Optional<GitLabNote> findExistingReportingNote(GitLabIssue gitLabIssue, String signature, GitLabClient client) {
        Optional<GitLabNote> existingNote = this.findNoteWithSignature(gitLabIssue.getNotes(), signature);
        if (existingNote.isPresent()) {
            return existingNote;
        }
        if (gitLabIssue.getNotes().size() < 10) {
            return Optional.empty();
        }
        return this.findExistingReportingNoteInAllPages(gitLabIssue, signature, client);
    }

    private Optional<GitLabNote> findExistingReportingNoteInAllPages(GitLabIssue gitLabIssue, String signature, GitLabClient client) {
        GitLabClient.Page<List<GitLabNote>> page;
        String cursor = null;
        do {
            Optional<GitLabNote> existingNote;
            if (!(existingNote = this.findNoteWithSignature((page = client.getNoteClient().getIssueNotesPage(gitLabIssue.getGlobalId(), cursor)).items(), signature)).isPresent()) continue;
            return existingNote;
        } while ((cursor = page.endCursor()) != null);
        return Optional.empty();
    }

    private Optional<GitLabNote> findNoteWithSignature(List<GitLabNote> notes, String signature) {
        if (notes == null) {
            return Optional.empty();
        }
        return notes.stream().filter(note -> note.getBody().endsWith(signature)).findFirst();
    }

    private boolean noteBodyChanged(@NotNull String oldBody, @NotNull String newBody) {
        return !StringUtils.trimAllWhitespace((String)oldBody).equals(StringUtils.trimAllWhitespace((String)newBody));
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

