/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.service.execplan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanGitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanTestCase;
import org.squashtest.tm.plugin.xsquash4gitlab.service.execplan.ExecPlanSynchronizationDao;
import org.squashtest.tm.plugin.xsquash4gitlab.service.execplan.ExecplanIssuePartition;

@Service(value="squash.tm.plugin.xsquash4gitlab.execplanTestcaseService")
@Transactional
public class ExecplanTestCaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecplanTestCaseService.class);
    @Inject
    private ExecPlanSynchronizationDao execPlanSynchronizationDao;

    List<ExecplanTestCase> findTestCasesForIssues(Collection<ExecplanGitLabIssue> fromGitLab) {
        LOGGER.debug("retrieving relevant test cases related to the GitLab issues");
        ExecplanIssuePartition partition = this.partitionGitLabIssues(fromGitLab);
        List<ExecplanTestCase> featureTestcases = this.loadTestCasesCoveringFeatures(partition);
        List<ExecplanTestCase> bugfixTestcases = this.loadTestCasesFixedBy(partition);
        return this.mergeTestCases(featureTestcases, bugfixTestcases);
    }

    ExecplanIssuePartition partitionGitLabIssues(Collection<ExecplanGitLabIssue> fromGitLab) {
        List<String> keys2 = fromGitLab.stream().map(ExecplanGitLabIssue::getId).collect(Collectors.toList());
        LOGGER.debug("partitioning GitLab issues : {}", keys2);
        Set<String> features = this.execPlanSynchronizationDao.filterFeatures(keys2);
        Set<String> bugs = this.execPlanSynchronizationDao.filterBugfixes(keys2);
        Set<String> covered = this.execPlanSynchronizationDao.filterCoveredFeatures(keys2);
        ExecplanIssuePartition partition = new ExecplanIssuePartition();
        for (ExecplanGitLabIssue issue : fromGitLab) {
            boolean related = false;
            String key = issue.getId();
            issue.resetSyncFlags();
            if (features.contains(key)) {
                related = true;
                partition.addFeature(issue);
                issue.setSyncedAsFeature(Boolean.TRUE);
            }
            if (bugs.contains(key)) {
                related = true;
                partition.addBugfix(issue);
                issue.setSyncedAsIssue(Boolean.TRUE);
            }
            if (covered.contains(key)) {
                related = true;
                partition.addCoveredFeature(issue);
                issue.setFeatureIsCovered(Boolean.TRUE);
            }
            if (related) continue;
            partition.addUnrelated(issue);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("done partitioning");
            LOGGER.debug(partition.log());
        }
        return partition;
    }

    private List<ExecplanTestCase> loadTestCasesCoveringFeatures(ExecplanIssuePartition partition) {
        Set<String> featureKeys = partition.getCoveredFeatureKeys();
        LOGGER.debug("retrieving test cases from the database from the database covered by shipped features : {}", featureKeys);
        List<ExecplanTestCase> featureTestcases = this.execPlanSynchronizationDao.findTestCasesCoveringFeatures(featureKeys);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("retrieved feature test cases : {}", featureTestcases.stream().map(tc -> tc.getId()).collect(Collectors.toList()));
        }
        return featureTestcases;
    }

    private List<ExecplanTestCase> loadTestCasesFixedBy(ExecplanIssuePartition partition) {
        Set<String> fixKeys = partition.getBugFixKeys();
        LOGGER.debug("retrieving test cases from the database from the database covered by shipped bugfixes : {}", fixKeys);
        List<ExecplanTestCase> fixTestcases = this.execPlanSynchronizationDao.findTestCasesFixedBy(partition.getBugFixKeys());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("retrieved fixed test cases : {}", fixTestcases.stream().map(tc -> tc.getId()).collect(Collectors.toList()));
        }
        for (ExecplanTestCase testCase : fixTestcases) {
            for (ExecplanGitLabIssue sqIssue : testCase.getIssues()) {
                ExecplanGitLabIssue fromGitLab = partition.getBugfix(sqIssue.getId());
                if (fromGitLab != null) {
                    sqIssue.mergeWith(fromGitLab);
                    continue;
                }
                this.logIssueIsUnknown(testCase, sqIssue);
            }
        }
        return fixTestcases;
    }

    private List<ExecplanTestCase> mergeTestCases(Collection<ExecplanTestCase> listA, Collection<ExecplanTestCase> listB) {
        if (listA.isEmpty() && listB.isEmpty()) {
            LOGGER.debug("no test cases to merge");
            return Collections.emptyList();
        }
        LOGGER.debug("merging the test cases in a single model");
        ArrayList<ExecplanTestCase> allTestcases = new ArrayList<ExecplanTestCase>(listA.size() + listB.size());
        allTestcases.addAll(listA);
        allTestcases.addAll(listB);
        Collections.sort(allTestcases, (tc1, tc2) -> tc1.getId() < tc2.getId() ? -1 : 1);
        Iterator iterator2 = allTestcases.iterator();
        ExecplanTestCase previous = (ExecplanTestCase)iterator2.next();
        while (iterator2.hasNext()) {
            ExecplanTestCase current = (ExecplanTestCase)iterator2.next();
            if (current.equals(previous)) {
                LOGGER.trace("test case {} present both as a feature and an issue : merging", (Object)current.getId());
                previous.mergeWith(current);
                iterator2.remove();
                continue;
            }
            previous = current;
        }
        LOGGER.debug("done");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("final test case collection (after merge) is : {}", allTestcases.stream().map(ExecplanTestCase::getId).collect(Collectors.toList()));
        }
        return allTestcases;
    }

    private void logIssueIsUnknown(ExecplanTestCase testCase, ExecplanGitLabIssue sqIssue) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("test case '{}' reported that it's affected by issue '{}', which could not be found in the original set of GitLab issues", (Object)testCase.getId(), (Object)sqIssue.getId());
        }
    }
}

